import java.util.*;

public class Yukkuri {	
	private final static int ALARM_PERIOD = 300; // 30 seconds

	public static ArrayList<Body> bodyList = new ArrayList<Body>();
	public static ArrayList<Food> foodList = new ArrayList<Food>();
	public static ArrayList<Shit> shitList = new ArrayList<Shit>();
	public static ArrayList<Toilet>	toiletList = new ArrayList<Toilet>();

	private static Random rnd = new Random();
	private static int alarmPeriod = 0;
	private static boolean alarm = false;
	private static ArrayList<Body> babyList = new ArrayList<Body>();

	private int distance(int x, int y) {
		return x*x + y*y;
	}

	public static void saveState(java.io.File filename) throws java.io.IOException {
		java.io.ObjectOutputStream out =
				new java.io.ObjectOutputStream(
						new java.io.BufferedOutputStream(
								new java.io.FileOutputStream(filename)));
		try {
			out.writeUTF(Yukkuri.class.getCanonicalName());
			out.writeInt(alarmPeriod);
			out.writeBoolean(alarm);
			out.writeObject(rnd);
			out.writeObject(bodyList);
			out.writeObject(foodList);
			out.writeObject(shitList);
			out.writeObject(toiletList);
			out.flush();
		} finally {
			out.close();
		}
	}

	@SuppressWarnings("unchecked")
	public static void loadState(java.io.File filename) throws java.io.IOException, ClassNotFoundException {
		java.io.ObjectInputStream in =
				new java.io.ObjectInputStream(
						new java.io.BufferedInputStream(
								new java.io.FileInputStream(filename)
								));
		int alarmPeriod;
		boolean alarm;
		Random rnd;
		ArrayList<Body> bodyList;
		ArrayList<Food> foodList;
		ArrayList<Shit> shitList;
		ArrayList<Toilet> toiletList;
		try {
			String s = in.readUTF();
			if(!Yukkuri.class.getCanonicalName().equals(s)) {
				String errMsg = "Bad save: "+s;
				throw new java.io.IOException(errMsg);
			}
			alarmPeriod = in.readInt();
			alarm = in.readBoolean();
			rnd = (Random)in.readObject();
			bodyList = (ArrayList<Body>)in.readObject();
			foodList = (ArrayList<Food>)in.readObject();
			shitList = (ArrayList<Shit>)in.readObject();
			toiletList = (ArrayList<Toilet>)in.readObject();
		} finally {
			in.close();
		}
		Yukkuri.rnd = rnd;
		Yukkuri.alarmPeriod = alarmPeriod;
		Yukkuri.alarm = alarm;
		Yukkuri.bodyList = bodyList;
		Yukkuri.foodList = foodList;
		Yukkuri.shitList = shitList;
		Yukkuri.toiletList = toiletList;
	}

	private boolean checkPartner(Body b) {
		if (b.isDead() || b.isSleeping() || b.isScare()) {
			return false;
		}
		boolean ret = false;
		Body found = null;
		int minDistance = Box.maxX * Box.maxY;
		if (b.isExciting() && b.partner != null && !b.partner.isDead() && !b.isRaper()) {
			found = b.partner;
			minDistance = distance(b.getX()-found.getX(), b.getY()-found.getY());
		}
		else {
			// find nearest neighbor
			for (Body partner:bodyList) {
				if (partner == b) {
					continue;
				}
				if (b.getZ() != partner.getZ()) {
					continue;
				}
				if (b.isExciting()) {
					if (partner.isDead() && partner.hasAccessory()) {
						continue;
					}
					if (!b.isRaper() && (!partner.isAdult() || partner.isChild(b) || partner.isParent(b))) {
						continue;
					}
				}
				int dist, dx, dy;
				dx = b.getX() - partner.getX();
				dy = b.getY() - partner.getY();
				dist = distance(dx, dy);
				if (minDistance > dist) {
					found = partner;
					minDistance = dist;
				}
			}
		}
		if (found != null) {
			if (minDistance <= distance(b.getStep(), b.getStep())) {
				if (!found.isDead()) {
					if (b.isExciting()) {
						if (!b.isTalking()) {
							b.doSukkiri(found);
						}
					}
					else if (!found.hasAccessory() && b.hasAccessory()) {
						if (!b.isTalking()) {
							b.showHateYukkuri();
							found.strikeByNeedle();
						}
					}
					else if (b.isAdult() && !found.isAdult() && (found.isChild(b) || b.isMotherhood(found)) && found.isDirty()) {
						if (!b.isTalking()) {
							b.doPeropero(found);
						}
					}
					else if (b.isParent(found)) {
						if (!b.isTalking()) {
							b.doPeropero(found);
						}
					}
					else if (found.isPartner(b) || found.isParent(b)) {
						if (!b.isTalking()) {
							b.doSurisuri(found);
						}
					}
				}
				else {
					if (!found.hasAccessory()) {
						// yukkuri recognizes it is food.
						if (b.isHungry()) {
							if (!b.isTalking()) {
								b.eatFood(Food.type.BODY, Math.min(b.getEatAmount(), found.getAmount()));
								found.eatBody(Math.min(b.getEatAmount(), found.getAmount()));
							}
							ret = true;
						}
					}
					else if (b.isAdult()) {
						if (!b.isTalking()) {
							if (b.isParent(found)) {
								b.showSadnessForChild();
							}
							else if (b.isPartner(found)) {
								b.showSadnessForPartner(found);
							}
						}
					}
				}
			}
			else {
				if (!found.isDead()) {
					if (b.isExciting()) {
						// Exciting yukkuri goes to partner.
						b.moveToSukkiri(found.getX(), found.getY());
						ret = true;
					}
					else if (!found.hasAccessory() && b.hasAccessory() && rnd.nextInt(10) == 0) {
						if (!b.isTalking()) {
							// Yukkuris strikes a yukkuri without accessory.
							b.showHateYukkuri();
						}
						b.moveTo(found.getX(), found.getY());
					}
					else if (b.isChild() && found.isParent(b)) {
						// Koyukkuris goes to Parents.
						b.moveTo(found.getX(), found.getY());
					}
					else if (b.isAdult() && !found.isAdult() && (found.isChild(b) || b.isMotherhood(found)) && found.isDirty()) {
						// Adult yukkuri takes care of dirty koyukkuri.
						b.moveTo(found.getX(), found.getY());
					}
				}
				else {
					if (!found.hasAccessory()) {
						if (b.isHungry()) {
							if (!b.isTalking()) {
								b.moveToFood(found.getX(), found.getY());
							}
							ret = true;
						}
					}
					else if (rnd.nextInt(10) == 0) {
						if (b.isAdult()) {
							if (b.isParent(found) || b.isPartner(found)) {
								b.moveTo(found.getX(), found.getY());
							}
							else {
								b.lookTo(found.getX(), found.getY());
							}
						}
						else {
							b.runAway(found.getX(), found.getY());
						}
						if (!b.isTalking()) {
							b.showScare();
						}
					}
				}
			}
		}
		return ret;
	}

	private boolean checkFood(Body b) {
		boolean ret = false;
		if (b.isSleeping() || b.isDead() || b.isFull()) {
			return false;
		}
		if (!b.isRude() && b.wantToShit()) {
			return false;
		}
		Food found = null;
		int minDistance = Box.maxX * Box.maxY;
		for (Food f:foodList) {
			if (f.isEmpty()) {
				continue;
			}
			if (b.getZ() != f.getZ()) {
				continue;
			}
			int distance, dx, dy;
			dx = b.getX() - f.getX();
			dy = b.getY() - f.getY();
			distance = distance(dx, dy);
			if (minDistance > distance) {
				found = f;
				minDistance = distance;
			}
		}
		if (found != null) {
			if (minDistance <= distance(b.getStep(), b.getStep())) {
				if (!b.isTalking()) {
					b.eatFood(found.getFoodType(), Math.min(b.getEatAmount(), found.getAmount()));
					found.eatFood(Math.min(b.getEatAmount(), found.getAmount()));
				}
				ret = true;
			} else {
				if (b.isHungry()) {
					if (!b.isTalking()) { // moveToFood() will overwrite the message, so it needs to check.
						// go to nearest food
						b.moveToFood(found.getX(), found.getY());
					}
					ret = true;
				}
			}
		}
		else {
			if (b.isHungry()) {
				if (!b.isTalking() && (rnd.nextInt(10) == 0)) {
					b.showNoFood();
				}
			}
		}
		return ret;
	}

	private boolean checkShit(Body b) {
		boolean ret = false;
		Shit found = null;
		int minDistance = Box.maxX * Box.maxY;
		for (Shit s:shitList) {
			if (b.getZ() != s.getZ()) {
				continue;
			}
			int distance, dx, dy;
			dx = b.getX() - s.getX();
			dy = b.getY() - s.getY();
			distance = distance(dx, dy);
			if (minDistance > distance) {
				found = s;
				minDistance = distance;
			}
		}
		if (found != null) {
			if (minDistance <= distance(b.getStep(), b.getStep())) {
				if (b.isTooHungry()) {
					if (!b.isTalking()) {
						b.eatFood(Food.type.SHIT, b.getEatAmount());
						found.eatShit(b.getEatAmount());
					}
					ret = true;
				}
				else if (!b.isSleeping() && !b.isExciting()) {
					if (!b.isTalking()) {
						b.showHateShit();
					}
				}
			}
			else {
				if (b.isTooHungry()) {
					b.moveToShit(found.getX(), found.getY());
					ret = true;
				}
			}
		}
		return ret;
	}

	private boolean checkToilet(Body b) {
		boolean ret = false;
		Toilet found = null;
		int minDistance = Box.maxX * Box.maxY;
		for (Toilet t:toiletList) {
			int distance, dx, dy;
			dx = b.getX() - t.getX();
			dy = b.getY() - t.getY() - t.getSize()/6;
			distance = distance(dx, dy);
			if (minDistance > distance) {
				found = t;
				minDistance = distance;
			}
		}
		if (found != null) {
			if (b.wantToShit()) {
				b.moveToToilet(found.getX(), found.getY() - found.getSize()/6);
				ret = true;
			}
		}
		return ret;
	}

	private void addBaby(int x, int y, int z, int type, Body p1, Body p2) {
		babyList.add(makeBody(x, y, z, type, Body.AgeState.BABY, p1, p2));
	}

	public Body makeBody(int x, int y, int z, int type, Body.AgeState age, Body p1, Body p2) {
		Body b;
		switch (type) {
		case Marisa.type:
			b = new Marisa(x, y, z, age, p1, p2);
			break;
		case Reimu.type:
			b = new Reimu(x, y, z, age, p1, p2);
			break;
		case Alice.type:
			b = new Alice(x, y, z, age, p1, p2);
			break;
		case WasaReimu.type:
			b = new WasaReimu(x, y ,z, age, p1, p2);
			break;
		case MarisaReimu.type:
			b = new MarisaReimu(x, y, z, age, p1, p2);
			break;
		case ReimuMarisa.type:
			b = new ReimuMarisa(x, y, z, age, p1, p2);
			break;
		default:
			throw new RuntimeException("Unknown yukkuri type.");
		}
		return b;
	}

	public void addBody(int x, int y, int z, int type, Body.AgeState age, Body p1, Body p2) {
		bodyList.add(makeBody(x, y, z, type, age, p1, p2));
	}
	
	public void addBody(Body b) {
		bodyList.add(b);
	}

	public void addFood(int x, int y, Food.type type) {
		foodList.add(new Food(x, y, type));
	}

	public void addShit(int x, int y, int z, Body.AgeState ageState) {
		shitList.add(new Shit(x, y, z, ageState));
	}

	public void addCrushedShit(int x, int y, int z, Body.AgeState ageState) {
		Shit s = new Shit(x, y, z, ageState);
		s.crushShit();
		shitList.add(s);
	}

	public void addToilet(int x, int y) {
		toiletList.add(new Toilet(x, y));
	}

	public static void setAlarm() {
		alarm = true;
		alarmPeriod = ALARM_PERIOD;
	}

	public static boolean getAlarm() {
		return alarm;
	}

	public void run() {
		if (alarmPeriod >= 0) {
			alarmPeriod--;
			if (alarmPeriod <= 0) {
				alarmPeriod = 0;
				alarm = false;
			}
		}
		Obj.Event ret = Obj.Event.DONOTHING;
		// Update food state.
		for (Iterator<Food> i = foodList.iterator(); i.hasNext();) {
			Food f = i.next();
			ret = f.clockTick();
			if (ret == Obj.Event.REMOVED) {
				i.remove();
			}
		}
		// Update toilet state.
		for (Iterator<Toilet> i = toiletList.iterator(); i.hasNext();) {
			Toilet t = i.next();
			ret = t.clockTick();
			if (ret == Obj.Event.REMOVED) {
				i.remove();
			}
		}
		// Update shit state.
		for (Iterator<Shit> i = shitList.iterator(); i.hasNext();) {
			Shit s = i.next();
			ret = s.clockTick();
			if (ret == Obj.Event.REMOVED) {
				i.remove();
			}
		}
		// update body state
		for (Iterator<Body> i = bodyList.iterator(); i.hasNext();) {
			Body b = i.next();
			b.putStress(bodyList.size()); // Yukkuri is getting stress according as number of bodies.
			ret = b.clockTick();
			switch (ret) {
			case DEAD:
				continue;
			case BIRTHBABY:
				for (int babyType:b.getBabyTypes()) {
					addBaby(b.getX(), b.getY(), b.getZ(), babyType, b, b.partner);
				}
				b.getBabyTypes().clear();
				break;
			case DOSHIT:
				addShit(b.getX(), b.getY(), b.getZ(), b.getAgeState());
				break;
			case REMOVED:
				i.remove();
				continue;
			default:
				break;
			}
			// check Sukkiri
			if (!checkPartner(b)) {
				// check Food
				if (!checkFood(b)) {
					// check shit
					if (!checkShit(b)) {
						// check toilet
						checkToilet(b);
					}
				}
			}
		}
		// add babies.
		if (!babyList.isEmpty()) {
			bodyList.addAll(babyList);
			babyList.clear();
		}
	}
}
