/* 
 *    Copyright 2013 Mimisuke
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Food extends Obj implements java.io.Serializable {
	static final long serialVersionUID = 2L;

	public enum type {SHIT, YUKKURIFOOD, BITTER, SELFFEEDER, LEMONPOP, HOT, VIYUGRA, BODY};
	// for food
	public static final int FOOD_EMPTY = 0;
	public static final int FOOD_NOT_EMPTY_NORMAL = 1;
	public static final int FOOD_NOT_EMPTY_BITTER = 2;
	public static final int FOOD_NOT_EMPTY_LEMON = 3;
	public static final int FOOD_NOT_EMPTY_HOT = 4;
	public static final int FOOD_NOT_EMPTY_VIYUGRA = 5;
	public static final int FOOD_SHADOW = 6;
	public static final int NUM_OF_FOOD_STATE = 7;

	private type foodType;
	private int amount;

	private static final int foodSize = 64;
	private static Image[] images = new Image[NUM_OF_FOOD_STATE];
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/";

		images[FOOD_EMPTY] = ImageIO.read(loader.getResourceAsStream(path+"gohan1.png"));
		images[FOOD_NOT_EMPTY_NORMAL] = ImageIO.read(loader.getResourceAsStream(path+"gohan2.png"));
		images[FOOD_NOT_EMPTY_BITTER] = ImageIO.read(loader.getResourceAsStream(path+"gohan3.png"));
		images[FOOD_NOT_EMPTY_LEMON] = ImageIO.read(loader.getResourceAsStream(path+"gohan4.png"));
		images[FOOD_NOT_EMPTY_HOT] = ImageIO.read(loader.getResourceAsStream(path+"gohan5.png"));
		images[FOOD_NOT_EMPTY_VIYUGRA] = ImageIO.read(loader.getResourceAsStream(path+"gohan6.png"));
		images[FOOD_SHADOW] = ImageIO.read(loader.getResourceAsStream(path+"gohan-shadow.png"));
		
		for (int i=0; i < NUM_OF_FOOD_STATE; i++) {
			images[i] = images[i].getScaledInstance(foodSize, foodSize/2, Image.SCALE_AREA_AVERAGING);
		}
	}
	
	public Image getImage() {
		if (isEmpty()) {
			return images[FOOD_EMPTY];
		}
		else {
			switch (foodType) {
			case YUKKURIFOOD:
			default:
				return images[FOOD_NOT_EMPTY_NORMAL];	
			case BITTER:
				return images[FOOD_NOT_EMPTY_BITTER];
			case LEMONPOP:
				return images[FOOD_NOT_EMPTY_LEMON];
			case HOT:
				return images[FOOD_NOT_EMPTY_HOT];
			case VIYUGRA:
				return images[FOOD_NOT_EMPTY_VIYUGRA];
			}
		}
	}
	
	public Image getShadowImage() {
		return images[FOOD_SHADOW];
	}
	
	public int getSize() {
		return foodSize;
	}
	
	public static int getSizeS() {
		return foodSize;
	}

	public Food(int initX, int initY, type initType) {
		objType = Type.FOOD;
		x = initX;
		y = initY;
		z = 0;
		foodType = initType;
		switch (initType) {
		case YUKKURIFOOD:
			amount = 100*24*24;
			break;
		case BITTER:
			amount = 100*24*24;
			break;
		default:
			amount = 100*24*24;
		}
		removed = false;
	}

	public type getFoodType() {
		return foodType;
	}

	public boolean isEmpty() {
		return (amount == 0);
	}
	
	public int getAmount() {
		return amount;
	}

	public void eatFood(int eatAmount)
	{
		if (isEmpty()) {
			return;
		}
		if (foodType == type.SELFFEEDER) {
			return;
		}
		amount -= eatAmount;
		if (amount < 0) {
			amount = 0;
		}
	}
	
	public void kick() {
		kick(0,  -8,  -4);
	}
}
