import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ProductChute extends ObjEX implements java.io.Serializable {
	static final long serialVersionUID = 1L;

	public static List<ObjEX> objEXList = new ArrayList<ObjEX>();

	public static final int type = 0;
	public static final int hitCheckObjType = 31;
	public static final int size = 128;
	private static final int images_num = 1; //このクラスの総使用画像数
	private static final int anime_pattern = 1; //このクラスのアニメーション数
	private static int AnimeImagesNum[] = {1};//アニメごとに何枚使うか
	private static Image[] images = new Image[images_num];
	protected Random rnd = new Random();
	private static int value = 5000;
	private static int cost = 10;
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/";
		images[0] = ImageIO.read(loader.getResourceAsStream(path+"productchute.png"));		
		images[0] = images[0].getScaledInstance(size*9/8, size*3/4, Image.SCALE_AREA_AVERAGING);
	}

	public Image getImage(){
		return images[0];
	}

	@Override
	public int getSize() {
		return size;
	}

	@Override
	public int getHitCheckObjType() {
		return hitCheckObjType;
	}

	@Override
	public int checkHitObj( Obj o ) {
		int objX = o.getX();
		int objY = o.getY();
		int objZ = o.getZ();
		int platformSize = getSize()/2;
		int platformX = getX();
		int platformY = getY();
		int platformZ = getZ();
		int offsetX = (Body.MAXSIZE - getSize())*7/32-28;
		int offsetY = (Body.MAXSIZE - getSize())*6/16-40;
			if ( objZ == 0 ){	//空中の物は移動させない
				if ((platformX + offsetX)<=(objX) && (objX)<=(platformX + offsetX + platformSize)){	//X軸比較
					if ((platformY + offsetY)<=(objY) && (objY)<=(platformY + offsetY + platformSize)){	//Y軸比較
						objHitProcess( o );
						return 1;
					}
				}
			}
		return 0;
	}

	@Override
	public int objHitProcess( Obj o ) {
		if ( o.objType == Obj.Type.YUKKURI ){
			Cash.addCash( -o.getValue()*10 );
		}else if ( o.objType == Obj.Type.FOOD ) {
				Cash.addCash( o.getValue()/2 );
		}else{
			Cash.addCash( -o.getValue()*2 );
		}
		Cash.addCash( -getCost() );
		o.remove();
		return 0;
	}
	
	@Override
	public int getValue() {
		return value;
	}

	@Override
	public int getCost() {
		return cost;
	}
	
	@Override
	public void removeListData(){
		objEXList.remove(this);
	}

	public ProductChute(int initX, int initY, Direction initDir) {
		super(initX, initY, ObjEX.Direction.BACK);
		objEXList.add(this);
		objType = Type.PLATFORM;
	}
}