/* 
 *    Copyright 2013 Mimisuke
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Toilet extends Obj implements java.io.Serializable {
	static final long serialVersionUID = 1L;

	private static final int toiletSize = 128;
	private static Image images;
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/";

		images = ImageIO.read(loader.getResourceAsStream(path+"toilet.png"));		
		images = images.getScaledInstance(toiletSize, toiletSize*2/3, Image.SCALE_AREA_AVERAGING);
	}
	
	public Image getImage() {
		return images;
	}
	
	public int getSize() {
		return toiletSize;
	}
	
	public static int getSizeS() {
		return toiletSize;
	}

	public Toilet(int initX, int initY) {
		objType = Type.TOILET;
		x = initX;
		y = initY;
		z = 0;
	}
}