import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Beltconveyor extends Platform implements java.io.Serializable {
	static final long serialVersionUID = 1L;

	public static final int type = 0;
	public static final int size = 128;
	private static final int images_num = 10; //このクラスの総使用画像数
	private static final int anime_pattern = 2; //このクラスのアニメーション数
	private static int AnimeImagesNum[] = {5,5};//アニメごとに何枚使うか
	private static Image[] images = new Image[images_num];

	private int beltSpeed;
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/beltconveyor/";
		for( int i = 0; i < images_num ; i++ ){
			images[i] = ImageIO.read(loader.getResourceAsStream(path+"beltconveyor"+String.format("%03d",i+1)+".png"));		
			images[i] = images[i].getScaledInstance(size*9/8, size*3/4, Image.SCALE_AREA_AVERAGING);
		}
	}
	
	public Image getImage() {
		switch ( direction ) {	//楽にアニメ指定できるようにしたいが後で
			case BACK:
			default:
				return images[(int)age/4%AnimeImagesNum[0]];	//4フレームに1回画像更新
			case THISSIDE:
				return images[4-((int)age/4%AnimeImagesNum[0])];
			case RIGHT:
				return images[9-(int)age/4%AnimeImagesNum[1]];
			case LEFT:
				return images[5+((int)age/4%AnimeImagesNum[1])];
		}
	}
	
	public int getSize() {
		return size;
	}

	public int getBeltSpeed() {
		return beltSpeed;
	}
	
	public int run( Obj o ) {
		int objX = o.getX();
		int objY = o.getY();
		int objSize = o.getSize();
		if (  !Terrarium.onBarrier( objX, objY, objSize/2, objSize/4 ) ) {		//壁にひっかかっていれば移動させない
			switch ( getDirection() ) {	//移動させる方向
				case BACK:
				default:
					o.setY(objY-beltSpeed);
					break;
				case THISSIDE:
					o.setY(objY+beltSpeed);
					break;
				case RIGHT:
					o.setX(objX+beltSpeed);
					break;
				case LEFT:
					o.setX(objX-beltSpeed);
					break;
			}
		}
		return 0;
	}

	public Beltconveyor(int initX, int initY, Direction initDir) {
		super(initX, initY, initDir);
		beltSpeed = 1;
	}
}