/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService.dbobject;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import jdbcacsess2.sqlService.ReferenceColumnResult;

/**
 * @author sima
 *
 */
public class PropertyExportedKeyTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 6816351858372050538L;
	private final List<ReferenceColumnResult> exportKey;

	public PropertyExportedKeyTableModel(List<ReferenceColumnResult> exportKey) {
		this.exportKey = exportKey;
	}

	private final String[] header = { "PKcat", "PKschem", "PKtable", "PKname", "PKcolumn", "FKcat", "FKschem",
	                                  "FKtable", "FKname", "FKcolumn", "KeySeq", "UpdateRule", "DeleteRule",
	"Deferrability" };

	@Override
	public int getColumnCount() {
		return exportKey.size() + 1;
	}

	@Override
	public int getRowCount() {
		return 14;
	}

	@Override
	public String getColumnName(int column) {
		if (column == 0) {
			return "";
		}
		return Integer.toHexString(column);
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {

		if (columnIndex == 0) {
			return header[rowIndex];
		}

		ReferenceColumnResult r = exportKey.get(columnIndex - 1);

		switch (rowIndex) {
		case 0:
			return r.getPktableCat();
		case 1:
			return r.getPktableSchem();
		case 2:
			return r.getPktableName();
		case 3:
			return r.getPkName();
		case 4:
			return r.getPkcolumnName();

		case 5:
			return r.getFktableCat();
		case 6:
			return r.getFktableSchem();
		case 7:
			return r.getFktableName();
		case 8:
			return r.getFkName();
		case 9:
			return r.getFkcolumnName();

		case 10:
			return r.getKeySeq();

		case 11:
			return r.getUpdateRuleName();
		case 12:
			return r.getDeleteRuleName();

		case 13:
			return r.getDeferrabilityName();
		}
		return null;
	}

}
