/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Icon;

import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

/**
 * データベースオブジェクトの最上位階層
 * 
 * @author sima
 * 
 */
public class DBObjectsRoot extends DBObjects {

	static final String[] header = { "ROOT" };

	private ArrayList<DBObjectRoot> root = new ArrayList<DBObjectRoot>();

	/**
	 * コンストラクタ
	 * 
	 * @param dmd
	 * @throws SQLException
	 */
	public DBObjectsRoot(DatabaseMetaData dmd) throws SQLException {
		root.add(new DBObjectRoot());
	}

	@Override
	public ArrayList<? extends DBObject> getDBObjects() {
		return root;
	}

	@Override
	public String toString() {
		return "ROOTS";
	}

	/**
	 * 最上位階層のプロパティ
	 * 
	 * @author sima
	 * 
	 */
	public static class DBObjectRoot extends DBObject {


		/*
		 * (非 Javadoc)
		 * 
		 * @seejdbcacsess2.sqlService.dbobject.DBObject#getChildren(java.sql.
		 * DatabaseMetaData)
		 */
		@Override
		public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
			DBObjects dbObjects = new DBObjectCatalogs(dmd);
			if (dbObjects.getDBObjects().size() == 0) {
					dbObjects = new DBObjectSchemas(null, dmd);
					if (dbObjects.getDBObjects().size() == 0) {
						dbObjects = new DBObjectTableTypes(null, null, dmd);
					}
				}
			return dbObjects;
		}

		@Override
		public List<Property> getProperties() {
			return null;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getIconImage()
		 */
		@Override
		public Icon getIconImage() {
			return DbObjectIconImage.ROOT.getValue();
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getName()
		 */
		@Override
		public String getName() {
			return "root name";
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#isStrong()
		 */
		@Override
		public boolean isStrong() {
			return false;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#isBottom()
		 */
		@Override
		public boolean isBottom() {
			return false;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getSummary()
		 */
		@Override
		public String getSummary() {
			return "root";
		}

		@Override
		public boolean isPropertyEnable() {
			return false;
		}
	}

}
