/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService;

import java.util.List;

public class StringConncat {

	private String delim;
	private String firstDelim;
	private String lastDelim;

	private StringBuilder buf;
	private boolean first;

	public StringConncat(String delim) {
		this(delim, "", "");
	}

	public StringConncat(String delim, String firstDelim, String lastDelim) {
		buf = new StringBuilder();
		first = true;

		this.delim = delim;
		this.firstDelim = firstDelim;
		this.lastDelim = lastDelim;
	}

	public void append(String str) {
		if (first) {
			buf.append(firstDelim);
		} else {
			buf.append(delim);
		}

		buf.append(str);
		first = false;
	}

	@Override
    public String toString() {
		buf.append(lastDelim);
		return buf.toString();
	}

	public void clear() {
		buf = new StringBuilder();
		first = true;
	}

	static public String arrayToString(List<?> list, String delim) {
		return arrayToString(list.toArray(), delim);
	}

	static public String arrayToString(Object[] list, String delim) {
		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < list.length; i++) {
			if (i == 0) {
				sb.append(delim);
			}
			sb.append(list[i]);
		}

		return sb.toString();
	}
}
