/*
 * Copyright 2012 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.main;

import java.sql.SQLException;

import jdbcacsess2.main.ConfigProperty.Type;
import net.java.ao.DBParam;
import net.java.ao.EntityManager;
import net.java.ao.Query;

public class OptionValues {
	private final EntityManager entityManager;

	public Prop<Integer> propTimeOutSeconds = new Prop<Integer>("TIMEOUT_SECONDS", 5);
	/**
	 * １回あたりの検索結果最大取得行数
	 */
	public Prop<Integer> propResultrowsLimitCnt = new Prop<Integer>("RESULTROWS_LIMITCNT", 5000);

	OptionValues(EntityManager entityManager) {
		this.entityManager = entityManager;
	}

	public class Prop<T> {
		private final String name;
		private final T defaultValue;
		private final Class<? extends Object> c;

		Prop(String name, T defaultValue) {
			this.name = name;
			c = defaultValue.getClass();
			this.defaultValue = defaultValue;
		}

		public T getValue() {
			ConfigProperty[] e;
			try {
				e = entityManager.find(ConfigProperty.class, Query.select().where("NAME=?", name));
				if (e.length != 0) {
					switch (e[0].getType()) {
					case STRING:
						return (T) e[0].getValue();
					case NUMBER:
						try {
							return (T) c.getConstructor(String.class).newInstance(e[0].getValue());
						} catch (Exception ex) {
							ShowDialog.errorMessage(ex);
							break;
						}
					case BOOLEAN:
						return (T) Boolean.valueOf(e[0].getValue());
					default:
						break;
					}
					return null;
				}
				Type type = Type.NUMBER;
				if (c == String.class) {
					type = Type.STRING;
				}
				if (c == Boolean.class) {
					type = Type.BOOLEAN;
				}
				ConfigProperty rtn =
						entityManager.create(ConfigProperty.class,
						                     new DBParam("NAME", name),
						                     new DBParam("TYPE", type),
						                     new DBParam("VALUE", defaultValue));
			} catch (SQLException e1) {
				ShowDialog.errorMessage(e1);
			}
			return defaultValue;
		}

		public void setValue(T value) throws SQLException {
			ConfigProperty[] e = entityManager.find(ConfigProperty.class, Query.select().where("NAME=?", name));
			if (e.length != 0) {
				e[0].setValue(value.toString());
				e[0].save();
			}
		}
	}
}
