/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.main;

import java.lang.Thread.UncaughtExceptionHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

/**
 * アプリケーションの起動メインクラス
 * 
 * @author sima
 * 
 */
public class Jdbcacsess2 {

	public static final Logger logger = Logger.getLogger(Jdbcacsess2.class.getName());

	// logging 内部でloggerは、弱参照で保持されている。強参照が無くなるとオブジェクトが消えてしまう。
	// ActiveObjects内部では、強参照保持していないので、AO利用者が保持してあげることにする。（泣
	public static final Logger loggerActiveObjects = Logger.getLogger("net.java.ao");

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		new Jdbcacsess2();
	}

	public Jdbcacsess2() {

		System.setProperty("awt.useSystemAAFontSettings", "on");
		logger.setLevel(Level.FINE);

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {

				setLookAndFeel();

				// Event dispatching thread の非チェック例外をキャッチする
				Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler() {
					public void uncaughtException(Thread t, Throwable e) {
						// ダイアログを表示する
						ShowDialog.errorMessage(e);
					}
				});
				try {
					Config config = new Config();

					// for (Entry<Object, Object> it :
					// UIManager.getLookAndFeelDefaults().entrySet()) {
					// if(it.getKey().toString().toLowerCase().endsWith("font"))
					// {
					// UIManager.put(it.getKey(), new Font("TakaoPGothic",
					// Font.PLAIN, 14));
					// }
					// }

					new MainController(config);

				} catch (Exception e) {
					ShowDialog.errorMessage(e);
				}
				logger.info("aplication startup end.");
			}
		});
	}

	private void setLookAndFeel() {
		try {
			for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (Exception e) {
			// If Nimbus is not available, you can set the GUI to another look
			// and feel.
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} catch (Exception e1) {
			}
		}
		UIManager.put("swing.boldMetal", Boolean.FALSE);
	}

}
