/*
 * Copyright 2012 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.main;

import java.sql.SQLException;

import net.java.ao.Entity;
import net.java.ao.EntityManager;
import net.java.ao.Preload;
import net.java.ao.ValueGenerator;
import net.java.ao.schema.Default;
import net.java.ao.schema.NotNull;

/**
 * @author sima
 *
 */
@Preload
public interface GuiDivider extends Entity {

	@NotNull
	@Default("0")
	Integer getLocation();
	void setLocation(Integer location);

	public class DividerGenerator implements ValueGenerator<GuiDivider> {
		/*
		 * (非 Javadoc)
		 * 
		 * @see net.java.ao.ValueGenerator#generateValue(net.java.ao.EntityManager)
		 */
		@Override
		public GuiDivider generateValue(EntityManager manager) {
			try {
				return manager.create(GuiDivider.class);
			} catch (SQLException e) {
				ShowDialog.errorMessage(e);
			}
			return null;
		}
	}

}
