/*
 * Copyright 2012 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.main;

import net.java.ao.Entity;
import net.java.ao.Preload;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.Unique;


/**
 * @author sima
 *
 */
@Preload
public interface ConfigProperty extends Entity {

	enum Type {
		STRING, NUMBER, BOOLEAN
	}

	@Unique
	@NotNull
	String getName();
	void setName(String name);

	@NotNull
	Type getType();
	void setType(Type name);

	@NotNull
	String getValue();
	void setValue(String value);

}
