/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Arrays;
import java.util.LinkedList;
import net.java.ao.EntityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseType<T> {
    private final int type;
    private final int defaultPrecision;
    private final Class<?>[] handledTypes;

    protected DatabaseType(int type, int defaultPrecision, Class<?> ... handledTypes) {
        this.type = type;
        this.defaultPrecision = defaultPrecision;
        this.handledTypes = handledTypes;
    }

    public int getType() {
        return this.type;
    }

    public int getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public boolean isHandlerFor(int type) {
        return this.type == type;
    }

    public boolean isHandlerFor(Class<?> type) {
        for (Class<?> handled : this.handledTypes) {
            if (!this.isSubclass(handled, type)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubclass(Class sup, Class sub) {
        if (sub.equals(sup)) {
            return true;
        }
        if (sub.equals(Object.class)) {
            return false;
        }
        Class superclass = sub.getSuperclass();
        LinkedList superclasses = new LinkedList();
        superclasses.addAll(Arrays.asList(sub.getInterfaces()));
        if (superclass != null) {
            superclasses.add(superclass);
        }
        for (Class clazz : superclasses) {
            if (!this.isSubclass(sup, clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldCache(Class<?> type) {
        return true;
    }

    public void putToDatabase(int index, PreparedStatement stmt, T value) throws SQLException {
        stmt.setObject(index, value, this.getType());
    }

    public boolean valueEquals(Object val1, Object val2) {
        return val1.equals(val2);
    }

    public abstract String getDefaultName();

    public abstract T pullFromDatabase(EntityManager var1, ResultSet var2, Class<? extends T> var3, String var4) throws SQLException;

    public T pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends T> type, int index) throws SQLException {
        return this.pullFromDatabase(manager, res, type, res.getMetaData().getColumnLabel(index));
    }

    public abstract Object defaultParseValue(String var1);

    public String valueToString(Object value) {
        return value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseType) {
            DatabaseType type = (DatabaseType)obj;
            if (type.type == this.type && type.defaultPrecision == this.defaultPrecision && Arrays.equals(type.handledTypes, this.handledTypes)) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hashCode = this.type + this.defaultPrecision;
        for (Class<?> type : this.handledTypes) {
            hashCode += type.hashCode();
        }
        return hashCode %= 256;
    }

    public String toString() {
        String back = "GENERIC";
        Class<Types> clazz = Types.class;
        for (Field field : clazz.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (!field.get(null).equals(this.type)) continue;
                back = field.getName();
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (this.defaultPrecision > 0) {
            back = back + "(" + this.defaultPrecision + ")";
        }
        return back;
    }
}

