/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.schema.AbstractFieldNameConverter;

public class UnderscoreFieldNameConverter
extends AbstractFieldNameConverter {
    private static final Pattern WORD_PATTERN = Pattern.compile("([a-z\\d])([A-Z\\d])");
    private boolean uppercase;

    public UnderscoreFieldNameConverter(boolean uppercase) {
        this.uppercase = uppercase;
    }

    public boolean isUppercase() {
        return this.uppercase;
    }

    protected String convertName(String name, boolean entity, boolean polyType) {
        Matcher matcher = WORD_PATTERN.matcher(name);
        String back = matcher.replaceAll("$1_$2");
        if (polyType) {
            back = back + "_type";
        } else if (entity) {
            back = back + "_id";
        }
        back = this.uppercase ? back.toUpperCase() : back.toLowerCase();
        return back.toString();
    }
}

