/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.java.ao.DatabaseProvider;
import net.java.ao.db.ClientDerbyDatabaseProvider;
import net.java.ao.db.EmbeddedDerbyDatabaseProvider;
import net.java.ao.db.HSQLDatabaseProvider;
import net.java.ao.db.JTDSSQLServerDatabaseProvider;
import net.java.ao.db.MySQLDatabaseProvider;
import net.java.ao.db.OracleDatabaseProvider;
import net.java.ao.db.PostgreSQLDatabaseProvider;
import net.java.ao.db.SQLServerDatabaseProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SupportedDBProvider {
    MYSQL("jdbc:mysql", MySQLDatabaseProvider.class),
    NETWORK_DERBY("jdbc:derby://", ClientDerbyDatabaseProvider.class),
    EMBEDDED_DERBY("jdbc:derby", EmbeddedDerbyDatabaseProvider.class),
    ORACLE_THIN("jdbc:oracle:thin", OracleDatabaseProvider.class),
    ORACLE_OCI("jdbc:oracle:oci", OracleDatabaseProvider.class),
    POSTGRESQL("jdbc:postgresql", PostgreSQLDatabaseProvider.class),
    MS_SQL_SERVER("jdbc:sqlserver", SQLServerDatabaseProvider.class),
    JTDS_MS_SQL_SERVER("jdbc:jtds:sqlserver", JTDSSQLServerDatabaseProvider.class),
    NETWORK_HSQLDB("jdbc:hsqldb://", HSQLDatabaseProvider.class),
    EMBEDDED_HSQLDB("jdbc:hsqldb", HSQLDatabaseProvider.class);

    private String prefix;
    private Class<? extends DatabaseProvider> type;

    private SupportedDBProvider(String prefix, Class<? extends DatabaseProvider> type) {
        this.prefix = prefix;
        this.type = type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Class<? extends DatabaseProvider> getType() {
        return this.type;
    }

    public DatabaseProvider createInstance(String uri, String username, String password) {
        DatabaseProvider back = null;
        try {
            Constructor<? extends DatabaseProvider> constructor = this.type.getDeclaredConstructor(String.class, String.class, String.class);
            constructor.setAccessible(true);
            back = constructor.newInstance(uri, username, password);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return back;
    }

    public static SupportedDBProvider getProviderForURI(String uri) {
        for (SupportedDBProvider provider : SupportedDBProvider.values()) {
            if (!uri.trim().startsWith(provider.prefix.trim())) continue;
            return provider;
        }
        return null;
    }
}

