/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import net.java.ao.DatabaseProvider;
import net.java.ao.PoolProvider;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxoolPoolProvider
extends PoolProvider {
    private static final String CLASSNAME = "org.logicalcobwebs.proxool.ProxoolDriver";
    private final String alias;

    public ProxoolPoolProvider(DatabaseProvider delegate) throws ProxoolException {
        this(delegate, "activeobjects");
    }

    public ProxoolPoolProvider(DatabaseProvider delegate, String alias) throws ProxoolException {
        super(delegate);
        this.alias = alias;
        try {
            this.getDriverClass();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        Properties props = new Properties();
        props.setProperty("proxool.maximum-connection-count", "30");
        props.setProperty("user", this.getUsername());
        props.setProperty("password", this.getPassword());
        String driverClass = null;
        try {
            driverClass = delegate.getDriverClass().getCanonicalName();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        String driverUrl = this.getURI();
        String url = "proxool." + alias + ":" + driverClass + ":" + driverUrl;
        ProxoolFacade.registerConnectionPool((String)url, (Properties)props);
    }

    @Override
    public Class<? extends Driver> getDriverClass() throws ClassNotFoundException {
        return Class.forName(CLASSNAME);
    }

    @Override
    protected Connection getConnectionImpl() throws SQLException {
        return DriverManager.getConnection("proxool." + this.alias);
    }

    @Override
    public void dispose() {
        try {
            ProxoolFacade.removeConnectionPool((String)this.alias);
        }
        catch (ProxoolException proxoolException) {
            // empty catch block
        }
    }

    public static boolean isAvailable() {
        try {
            Class.forName(CLASSNAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

