/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_SIZE = 16;
    private Set<K> keySet;
    private Collection<V> valuesCollection;
    private final ReferenceQueue<K> referenceQueue;
    int elementCount;
    Entry<K, V>[] elementData;
    private final int loadFactor;
    private int threshold;
    volatile int modCount;

    private static <K, V> Entry<K, V>[] newEntryArray(int size) {
        return new Entry[size];
    }

    public SoftHashMap() {
        this(16);
    }

    public SoftHashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = SoftHashMap.newEntryArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = 7500;
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public SoftHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = SoftHashMap.newEntryArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = (int)(loadFactor * 10000.0f);
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public SoftHashMap(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        super.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
            while (this.referenceQueue.poll() != null) {
            }
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)this.elementData.length * (long)this.loadFactor / 10000L);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.poll();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return SoftHashMap.this.size();
            }

            @Override
            public void clear() {
                SoftHashMap.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    SoftHashMap.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                Object key;
                Entry entry;
                if (object instanceof Map.Entry && (entry = SoftHashMap.this.getEntry(((Map.Entry)object).getKey())) != null && ((key = entry.get()) != null || entry.isNull)) {
                    return object.equals(entry);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new HashIterator(new Entry.Type<Map.Entry<K, V>, K, V>(){

                    @Override
                    public Map.Entry<K, V> get(Map.Entry<K, V> entry) {
                        return entry;
                    }
                });
            }
        };
    }

    @Override
    public Set<K> keySet() {
        this.poll();
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return SoftHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return SoftHashMap.this.size();
                }

                @Override
                public void clear() {
                    SoftHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    if (SoftHashMap.this.containsKey(key)) {
                        SoftHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new HashIterator(new Entry.Type<K, K, V>(){

                        @Override
                        public K get(Map.Entry<K, V> entry) {
                            return entry.getKey();
                        }
                    });
                }

                @Override
                public Object[] toArray() {
                    ArrayList coll = new ArrayList(this.size());
                    Iterator iter = this.iterator();
                    while (iter.hasNext()) {
                        coll.add(iter.next());
                    }
                    return coll.toArray();
                }

                @Override
                public <T> T[] toArray(T[] contents) {
                    ArrayList coll = new ArrayList(this.size());
                    Iterator iter = this.iterator();
                    while (iter.hasNext()) {
                        coll.add(iter.next());
                    }
                    return coll.toArray(contents);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        this.poll();
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return SoftHashMap.this.size();
                }

                @Override
                public void clear() {
                    SoftHashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return SoftHashMap.this.containsValue(object);
                }

                @Override
                public Iterator<V> iterator() {
                    return new HashIterator(new Entry.Type<V, K, V>(){

                        @Override
                        public V get(Map.Entry<K, V> entry) {
                            return entry.getValue();
                        }
                    });
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public V get(Object key) {
        this.poll();
        if (key != null) {
            int index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[index];
            while (entry != null) {
                if (key.equals(entry.get())) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry<K, V> entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry<K, V> getEntry(Object key) {
        this.poll();
        if (key != null) {
            int index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[index];
            while (entry != null) {
                if (key.equals(entry.get())) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry<K, V> entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        this.poll();
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    void poll() {
        Entry toRemove;
        while ((toRemove = (Entry)this.referenceQueue.poll()) != null) {
            this.removeEntry(toRemove);
        }
    }

    void removeEntry(Entry<K, V> toRemove) {
        Entry<K, V> last = null;
        int index = (toRemove.hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null) {
            if (toRemove == entry) {
                ++this.modCount;
                if (last == null) {
                    this.elementData[index] = entry.next;
                } else {
                    last.next = entry.next;
                }
                --this.elementCount;
                break;
            }
            last = entry;
            entry = entry.next;
        }
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> entry;
        this.poll();
        int index = 0;
        if (key != null) {
            index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && !key.equals(entry.get())) {
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                entry = entry.next;
            }
        }
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = key == null ? 0 : (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = new Entry<K, V>(key, value, this.referenceQueue);
            entry.next = this.elementData[index];
            this.elementData[index] = entry;
            return null;
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    private void rehash() {
        int length = this.elementData.length << 1;
        if (length == 0) {
            length = 1;
        }
        Entry<K, V>[] newData = SoftHashMap.newEntryArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                int index = entry.isNull ? 0 : (entry.hash & Integer.MAX_VALUE) % length;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllImpl(map);
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> entry;
        this.poll();
        int index = 0;
        Entry<K, V> last = null;
        if (key != null) {
            index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && !key.equals(entry.get())) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry != null) {
            ++this.modCount;
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            return entry.value;
        }
        return null;
    }

    @Override
    public int size() {
        this.poll();
        return this.elementCount;
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        if (map.entrySet() != null) {
            super.putAll(map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HashIterator<R>
    implements Iterator<R> {
        private int position = 0;
        private int expectedModCount;
        private Entry<K, V> currentEntry;
        private Entry<K, V> nextEntry;
        private K nextKey;
        final Entry.Type<R, K, V> type;

        HashIterator(Entry.Type<R, K, V> type) {
            this.type = type;
            this.expectedModCount = SoftHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null && (this.nextKey != null || this.nextEntry.isNull)) {
                return true;
            }
            while (true) {
                if (this.nextEntry == null) {
                    while (this.position < SoftHashMap.this.elementData.length && (this.nextEntry = SoftHashMap.this.elementData[this.position++]) == null) {
                    }
                    if (this.nextEntry == null) {
                        return false;
                    }
                }
                this.nextKey = this.nextEntry.get();
                if (this.nextKey != null || this.nextEntry.isNull) {
                    return true;
                }
                this.nextEntry = this.nextEntry.next;
            }
        }

        @Override
        public R next() {
            if (this.expectedModCount == SoftHashMap.this.modCount) {
                if (this.hasNext()) {
                    this.currentEntry = this.nextEntry;
                    this.nextEntry = this.currentEntry.next;
                    R result = this.type.get(this.currentEntry);
                    this.nextKey = null;
                    return result;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            if (this.expectedModCount != SoftHashMap.this.modCount) throw new ConcurrentModificationException();
            if (this.currentEntry == null) throw new IllegalStateException();
            SoftHashMap.this.removeEntry(this.currentEntry);
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<K, V>
    extends SoftReference<K>
    implements Map.Entry<K, V> {
        int hash;
        boolean isNull;
        V value;
        Entry<K, V> next;

        Entry(K key, V object, ReferenceQueue<K> queue) {
            super(key, queue);
            this.hash = key == null ? 0 : key.hashCode();
            this.value = object;
        }

        @Override
        public K getKey() {
            return (K)super.get();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V object) {
            V result = this.value;
            this.value = object;
            return result;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)other;
            Object key = super.get();
            return (key == null ? key == entry.getKey() : key.equals(entry.getKey())) && (this.value == null ? this.value == entry.getValue() : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash + (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return super.get() + "=" + this.value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static interface Type<R, K, V> {
            public R get(Map.Entry<K, V> var1);
        }
    }
}

