/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import net.java.ao.DelegateConnection;

class DelegateConnectionHandler
implements InvocationHandler {
    private Connection delegate;
    private boolean closeable;
    private boolean closed;

    private DelegateConnectionHandler(Connection delegate) {
        this.delegate = delegate;
        this.closeable = true;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("setCloseable")) {
            if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Boolean.TYPE)) {
                this.closeable = (Boolean)args[0];
                return Void.TYPE;
            }
        } else {
            if (method.getName().equals("isCloseable")) {
                return this.closeable;
            }
            if (method.getName().equals("close") && method.getParameterTypes().length == 0) {
                if (this.closeable) {
                    this.delegate.close();
                    this.closed = true;
                }
                return Void.TYPE;
            }
            if (method.getName().equals("isClosed") && method.getReturnType().equals(Boolean.TYPE)) {
                return this.closed;
            }
        }
        Class<?> clazz = this.delegate.getClass();
        Method method2 = clazz.getMethod(method.getName(), method.getParameterTypes());
        method2.setAccessible(true);
        return method2.invoke((Object)this.delegate, args);
    }

    public static DelegateConnection newInstance(Connection delegate) {
        return (DelegateConnection)Proxy.newProxyInstance(DelegateConnectionHandler.class.getClassLoader(), new Class[]{DelegateConnection.class}, (InvocationHandler)new DelegateConnectionHandler(delegate));
    }
}

