/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService.dbobject;


import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;


public class DBobjectMutableTreeTableNode extends AbstractMutableTreeTableNode {

	public DBobjectMutableTreeTableNode(DBObject userObject, boolean allowsChildren) {
		super(userObject, allowsChildren);
	}

	public DBObject getDBObject() {
		return (DBObject) getUserObject();
	}

	@Override
	public boolean isLeaf() {
		return !getAllowsChildren();
	}

	@Override
	public int getColumnCount() {
		return 5;
	}

	@Override
	public Object getValueAt(int column) {
		Object rtn = null;

		if (column == 0) {
			rtn = getDBObject();
		} else {
			if (getDBObject().isPropertyEnable()) {
				switch (column) {
				case 1:
					rtn = getDBObject().getProperty1();
					break;
				case 2:
					rtn = getDBObject().getProperty2();
					break;
				case 3:
					rtn = getDBObject().getProperty3();
					break;
				case 4:
					rtn = getDBObject().getProperty4();
					break;
				default:
					break;
				}
			}
		}
		return rtn;
	}
}
