/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService;

import java.util.ArrayList;
import java.util.HashMap;


/**
 * 同一SQL文を複数回数実行する際、入力パラメータの処理を実装する
 * 
 * @author sima
 * 
 */
public interface SqlExecuteParmeter {

	static public class Parameter {
		/**
		 * パラメータ値リスト
		 */
		public ArrayList<Object> values;

		/**
		 * パラメータリストのインデックスをキーとしたSQL型マップ
		 */
		public HashMap<Integer, ConstSqlTypes> sqlTypes;

	}

	/**
	 * 次のパラメータがあるか?
	 * 
	 * @return パラメータがありSQL文を実行する場合は true、終了の場合は false。
	 */
	public boolean hasNext();

	/**
	 * パラメータを設定する。
	 * 
	 */
	public Parameter getParameter();
}
