/*
 * Copyright 2012 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.main;

import java.awt.Font;
import java.sql.SQLException;

import jdbcacsess2.main.GuiFont.GuiFontImpl;
import net.java.ao.Entity;
import net.java.ao.EntityManager;
import net.java.ao.Implementation;
import net.java.ao.Preload;
import net.java.ao.ValueGenerator;
import net.java.ao.schema.Default;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.NotNull;

/**
 * @author sima
 *
 */
@Implementation(GuiFontImpl.class)
@Preload
public interface GuiFont extends Entity {

	public enum Style {
		PLAIN(Font.PLAIN), BOLD(Font.BOLD), ITALIC(Font.ITALIC), BOLD_ITALIC(Font.BOLD + Font.ITALIC);

		private final int style;

		public int getValue() {
			return style;
		}

		private Style(int style) {
			this.style = style;
		}

		public static Style searchStyle(int value) {
			for (Style i : Style.values()) {
				if (i.getValue() == value) {
					return i;
				}
			}
			return null;
		}
	}

	@NotNull
	@Default(" ")
	String getName();
	void setName(String name);

	@NotNull
	@Default("0")
	Style getStyle();
	void setStyle(Style style);

	@NotNull
	@Default("0")
	Integer getSize();
	void setSize(Integer size);

	@Ignore
	Font getFont();
	void setFont(Font font);

	public class FontGenerator implements ValueGenerator<GuiFont> {
		/*
		 * (非 Javadoc)
		 * 
		 * @see net.java.ao.ValueGenerator#generateValue(net.java.ao.EntityManager)
		 */
		@Override
		public GuiFont generateValue(EntityManager manager) {
			try {
				return manager.create(GuiFont.class);
			} catch (SQLException e) {
				ShowDialog.errorMessage(e);
			}
			return null;
		}
	}

	public class GuiFontImpl {
		private final GuiFont guiFont;

		public GuiFontImpl(GuiFont guiFont) {
			this.guiFont = guiFont;
		}

		public Font getFont() {
			return new Font(guiFont.getName(), guiFont.getStyle().getValue(), guiFont.getSize());
		}

		public void setFont(Font font) {
			guiFont.setName(font.getFontName());
			guiFont.setStyle(Style.searchStyle(font.getStyle()));
			guiFont.setSize(font.getSize());
		}

	}

}
