/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.main;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

import jdbcacsess2.sqlService.CodeAssistItem;
import jdbcacsess2.sqlService.CodeAssistModel;

public class CodeAssistView extends JDialog {

	void setLocation(JTextComponent jTextComponent) throws BadLocationException {
		Point p = jTextComponent.getLocationOnScreen();

		Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
		p.translate(rectangle.x + 2, rectangle.y + 10);

		setLocation(p);
	}

	public void setModel(CodeAssistModel codeAssistModel) {
		jList.setModel(codeAssistModel);
		jList.setSelectedIndex(0);
		setSize(400, getHeight());
	}

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JList<CodeAssistItem> jList = null;
	private JScrollPane jScrollPane = null;

	/**
	 * @param owner
	 */
	public CodeAssistView(Frame owner) {
		super(owner);
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		setSize(100, 200);
		setContentPane(getJContentPane());
		setUndecorated(true);
		setAlwaysOnTop(true);

		getJList().addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				Jdbcacsess2.logger.info(e.toString());
				CodeAssistView.this.setVisible(false);
			}
		});

		KeyStroke key_esc = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
		getRootPane().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(key_esc, "close");

		getRootPane().getActionMap().put("close", new AbstractAction() {
			private static final long serialVersionUID = -8760955090381970683L;

			@Override
			public void actionPerformed(ActionEvent e) {
				CodeAssistView.this.setVisible(false);
			}
		});

		KeyStroke key_enter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
		KeyStroke key_right = KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 0);
		KeyStroke key_space = KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, 0);
		getJList().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(key_enter, "select");
		getJList().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(key_right, "select");
		getJList().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(key_space, "select");

	}

	public void setActionSelected(Action action) {
		getJList().getActionMap().put("select", action);
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
			jContentPane.add(getJScrollPane(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jList
	 * 
	 * @return javax.swing.JList
	 */
	JList<CodeAssistItem> getJList() {
		if (jList == null) {
			jList = new JList<CodeAssistItem>();
			jList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		}
		return jList;
	}

	/**
	 * This method initializes jScrollPane
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getJList());
		}
		return jScrollPane;
	}

}
