/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.connect;

import net.java.ao.Entity;
import net.java.ao.OneToMany;
import net.java.ao.Preload;
import net.java.ao.schema.Default;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.Unique;

/**
 * DBMS製品毎のJDBC情報を永続化する為のActiveObjects用エンティティクラス
 * 
 * @author sima
 * 
 */
@Preload
public interface ConfigDbms extends Entity {
	@NotNull
	@Unique
	String getDbmsName();
	void setDbmsName(String dbmsName);

	@NotNull
	String getSubprotocol();
	void setSubprotocol(String subprotocol);

	@NotNull
	String getSubname();
	void setSubname(String subname);

	@NotNull
	String getDriverclass();
	void setDriverclass(String driverclass);

	@NotNull
	String getUrlOption();
	void setUrlOption(String urlOption);

	@NotNull
	@OneToMany
	ConfigConnect[] getConfigConnects();

	@NotNull
	@Default("00.0")
	String getVersion();
	void setVersion(String version);

	public static String DBMSNAME = "dbmsname";
	public static String SUBPROTOCOL = "subprotocol";
	public static String SUBNAME = "subname";
	public static String DRIVERCLASS = "driverclass";
	public static String URLOPTION = "urloption";
	public static String VERSION = "version";

}
