/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService.parse;

import java.util.regex.Pattern;

/**
 * @author sima
 *
 */
public interface SqlSentenceSparateListener {
	/**
	 * SQL文セパレータ
	 * 
	 * @param matchKeyword
	 *            マッチ文字
	 * @param beginPosition
	 *            開始位置
	 * @param endPosition
	 *            終了位置
	 * @param pattern
	 *            マッチ時の正規表現
	 */
	public void rangeSeparate(String matchKeyword, int beginPosition, int endPosition, Pattern pattern);

}
