package jp.sourceforge.shovel.servlet.shovel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Map.Entry;
//import java.util.concurrent.BlockingQueue;
//import java.util.concurrent.SynchronousQueue;

import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import jp.sourceforge.shovel.device.IDelayExecutor;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.thread.DelayExecutorQueue;

public class ShovelServlet extends GenericServlet {
    static final long serialVersionUID = -1L;
    
    Map<String, IDelayExecutor> createDelayExecutorMap() {
        Set<Entry<Object, Object>> entrySet = getProperties().entrySet();
        Map<String, IDelayExecutor> delayExecutorMap = new HashMap<String, IDelayExecutor>();
        for (Entry<Object, Object> entry: entrySet) {
            String[] tokens = entry.getKey().toString().split("\\.");
            String key = tokens[1];
            String value = entry.getValue().toString();
            
            IDelayExecutor device = delayExecutorMap.get(tokens[0]);
            //typeは必須
            if (device == null && key.compareToIgnoreCase("type") == 0) {
                device = (IDelayExecutor)getContainer().getComponent(value);
                delayExecutorMap.put(tokens[0], device);
            }
        }
        for (Entry<Object, Object> entry: entrySet) {
            String[] tokens = entry.getKey().toString().split("\\.");
            String key = StringUtils.join(tokens, ".", 1, tokens.length);
            String value = entry.getValue().toString();
            
            IDelayExecutor device = delayExecutorMap.get(tokens[0]);
            if (device == null) {
                continue;
            }
            device.setProperty(key, value);
        }
        return delayExecutorMap;
    }
    public void init(ServletConfig config) throws ServletException {
        DelayExecutorQueue queue = getDelayExecutorQueue();
        for (IDelayExecutor executor : createDelayExecutorMap().values()) {
            try {
                executor.connect();
                queue.addDelayExecutor(executor);
            } catch (ApplicationException e) {
            }
        }
        queue.start();
    }
    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
    IShovelLogic getShovelLogic() {
        return (IShovelLogic)getContainer().getComponent(IShovelLogic.class);
    }
    Properties getProperties() {
        return (Properties)getContainer().getComponent("imProperties");
    }
    DelayExecutorQueue getDelayExecutorQueue() {
        return (DelayExecutorQueue)getContainer().getComponent(DelayExecutorQueue.class);
    }
    @Override
    public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
    }
}
