package jp.sourceforge.shovel.entity.impl;

import org.seasar.dao.annotation.tiger.Bean;
import org.seasar.dao.annotation.tiger.Id;
import org.seasar.dao.annotation.tiger.IdType;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;

import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;

@Bean(table = "statuses")
public class StatusImpl implements IStatus {
    String body_;
    String location_;
    String source_;
    long referenceId_;
    long senderId_;
    long sentTime_;
    long statusId_;
    boolean open_;
    int givenFavorites_;
    long removedTime_;

    public String getBody() {
        return body_;
    }
    public void setBody(String status) {
        body_ = status;
    }
    public String getLocation() {
        return location_;
    }
    public void setLocation(String location) {
        location_ = location;
    }
    public String getSource() {
        return source_;
    }
    public void setSource(String source) {
        source_ = source;
    }
    public long getReferenceId() {
        return referenceId_;
    }
    public void setReferenceId(long referenceId) {
        referenceId_ = referenceId;
    }
    public long getSenderId() {
        return senderId_;
    }
    public void setSenderId(long senderId) {
        senderId_ = senderId;
    }
    public long getSentTime() {
        return sentTime_;
    }
    public void setSentTime(long sentTime) {
        sentTime_ = sentTime;
    }
    public long getStatusId() {
        return statusId_;
    }
    @Id(value = IdType.IDENTITY)
    public void setStatusId(long statusId) {
        statusId_ = statusId;
    }
    public boolean isOpen() {
        return open_;
    }
    public void setOpen(boolean open) {
        open_ = open;
    }
    public boolean isRemove() {
        return this.removedTime_ > 0;
    }
    public int getGivenFavorites() {
        return givenFavorites_;
    }
    public void setGivenFavorites(int givenFavorites) {
        givenFavorites_ = givenFavorites;
    }
    
    /////
    
    long referenceSenderId_;
    
    public long getReferenceSenderId() {
        return referenceSenderId_;
    }
    public void setReferenceSenderId(long referenceSenderId) {
        referenceSenderId_ = referenceSenderId;
    }
    
    /////
    
    IFavorite favorite_;
    IFavorite[] otherFavorites_;
    IUser sender_;
    IUser referenceSender_;
    IDedicatedClient client_;
    
    public IFavorite getFavorite() {
        return favorite_;
    }
    @Binding(bindingType=BindingType.NONE)
    public void setFavorite(IFavorite favorite) {
        favorite_ = favorite;
    }
    public IFavorite[] getOtherFavorites() {
        return otherFavorites_;
    }
    @Binding(bindingType=BindingType.NONE)
    public void setOtherFavorites(IFavorite[] otherFavorites) {
        otherFavorites_ = otherFavorites;
    }
    public IUser getSender() {
        return sender_;
    }
    @Binding(bindingType=BindingType.NONE)
    public void setSender(IUser sender) {
        sender_ = sender;
    }
    public IUser getReferenceSender() {
        return referenceSender_;
    }
    @Binding(bindingType=BindingType.NONE)
    public void setReferenceSender(IUser referenceSender) {
        referenceSender_ = referenceSender;
    }
    public IDedicatedClient getDedicatedClient() {
        return client_;
    }
    @Binding(bindingType=BindingType.NONE)
    public void setDedicatedClient(IDedicatedClient client) {
        client_ = client;
    }
    public long getRemovedTime() {
        return this.removedTime_;
    }
    public void setRemovedTime(long removedTime) {
        this.removedTime_ = removedTime;
    }
}
