package jp.sourceforge.shovel.entity.impl;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import jp.sourceforge.shovel.entity.ISize;

public class SizeImpl implements ISize {
    int width_;
    int height_;
    
    public ISize computeFitSize(int width, int height) {
        ISize size = (ISize)getContainer().getComponent(ISize.class);
        if (width > 0 && height > 0) {
            //原寸がサムネイルサイズより小さいなら計算しない
            if (width_ > width || height_ > height) {
                if ((width_ - width) > (height_ - height)) {
                    height = Math.round(((float)width / width_) * height_);
                } else {
                    width = Math.round(((float)height / height_) * width_);
                }
            } else if (width_ > 0 && height_ > 0){
                width = width_;
                height = height_;
            }
        } else if (width < 0) {
            width = Math.round(((float)height / height_) * width_);
        } else if (height < 0) {
            height = Math.round(((float)width / width_) * height_);
        }
        size.setWidth(width);
        size.setHeight(height);
        return size;
    }
    public int getWidth() {
        return width_;
    }
    public void setWidth(int width) {
        width_ = width;
    }
    public int getHeight() {
        return height_;
    }
    public void setHeight(int height) {
        height_ = height;
    }
    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}
