package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.impl.ServerFileImpl;

@S2Dao(bean = ServerFileImpl.class)
public interface IServerFileDao {
    int insert(IServerFile serverFile);
    
    @Arguments("serverFileIds")
    int deleteAll(long[] serverFileIds);
    
    @Arguments("serverFileId")
    IServerFile find(long serverFileId);
    @Arguments({"serverFileIds", "offset", "limit"})
    IServerFile[] findAll(long[] serverFileIds, int offset, int limit);
}
