package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.action.IShowStatusAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusForm;
import jp.sourceforge.shovel.service.IShovelService;

public class ShowStatusActionImpl implements IShowStatusAction {
    IStatusForm actionForm_;
    S2Container container_;
    HttpServletRequest request_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IShovelService shovelService = getShovelService();
        IStatus status = shovelService.getStatus(actionForm_.getStatusId());
        shovelService.prepareForView(status);
        request_.setAttribute("status", status);
        
        IUser sender = status.getSender();
        shovelService.prepareForView(sender);
        request_.setAttribute("user", sender);
        
        String forward = null;
        switch (actionForm_.getFormatType()) {
        case HTML:
            forward = SUCCESS;
            break;
        case JSON:
            forward = JSON;
            break;
        case XML:
            forward = XML;
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    public void setStatusForm(IStatusForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
