package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.SessionConst.S_LIST_REFINE;
import static jp.sourceforge.shovel.ViewType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IRepliesAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

//TODO 削除されたユーザーを友だちから削除
public class RepliesActionImpl implements IRepliesAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    
    @Perform(CSRF=false)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        request_.setAttribute("user", user);
        
        int page = actionForm_.getPage();
        int limit = actionForm_.getCount();
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)getSession().getAttribute(S_LIST_REFINE);
            if (listRefine == null || !listRefine.getViewType().isReplies()) {
                listRefine = (IListRefine)container_.getComponent(IListRefine.class);
                getSession().setAttribute(S_LIST_REFINE, listRefine);
            } else if (actionForm_.getMethodType().isPage()) {
                listRefine.setPage(actionForm_.getPage());
            }
            listRefine.setViewType(REPLIES);
            
            page = listRefine.getPage();
            limit = 0;
        }
        
        IStatus[] temp = shovelService.getReplies(user.getForeignKey(), page, limit);
        IStatus[] replies = shovelService.prepareForView(temp, limit, true);
        boolean nextPage = false;
        if (replies != null && replies.length > 0) {
            nextPage = temp.length > replies.length;
        }
        request_.setAttribute("statuses", replies);
        request_.setAttribute("nextPage", nextPage);
        
        String forward = null;
        switch (formatType) {
        case HTML:
            if (shovelService.isMobilePhone()) {
                request_.setAttribute("page", page);
                return MOBILE;
            }
            if (user != null) {
                shovelService.prepareForView(user);
                request_.setAttribute("user", user);
                String foreignKey = user.getForeignKey();
                IFriendship[] friendships = shovelService.getFriends(foreignKey, 0, 100);
                request_.setAttribute("viewAllFriends", friendships.length > 100);
                friendships = shovelService.prepareForView(friendships, 100, true);
                request_.setAttribute("friendships", friendships);
            }
            forward = actionForm_.isPartial() ? PARTIAL : FULL;
            break;
        case JSON:
        case XML:
            forward = formatType.getId();
            break;
        case RSS:
        case ATOM:
            shovelService.outputFeed(formatType, REPLIES, user, replies);
            break;
        default:
            throw new ApplicationException("");
        }
        
        return forward;
    }
    
    public void setStatusesForm(IStatusesForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    HttpSession getSession() {
        return request_.getSession(true);
    }
}
