package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.ICreateFriendshipAction;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class CreateFriendshipActionImpl implements ICreateFriendshipAction {
    HttpServletRequest request_;
    IFriendsForm actionForm_;
    
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        long userId = actionForm_.getUserId();
        String foreignKey = actionForm_.getForeignKey();
        IFriendship friend;
        if (foreignKey == null || foreignKey.length() <= 0) {
            IUser user = directoryService.getLoginUser();
            friend = shovelService.createFriendship(user.getUserId());
        } else if (foreignKey.matches("^[0-9]+$")) {
            foreignKey = null;
            friend = shovelService.createFriendship(userId);
        } else {
            userId = 0;
            friend = shovelService.createFriendship(foreignKey);
        }
        
        String forward = null;
        switch (formatType) {
        case HTML:
            if (shovelService.isMobilePhone()) {
                request_.setAttribute("post", "followFriend");
                forward = MOBILE;
            }
            break;
        case XML:
        case JSON:
            shovelService.prepareForView(new IFriendship[] {friend}, 1, false);
            request_.setAttribute("friendship", friend);
            request_.setAttribute("friends", true);
            
            IStatus status = null;
            if (userId > 0) {
                status = shovelService.getRecent(userId);
            } else {
                status = shovelService.getRecent(foreignKey);
            }
            
            if (status != null) {
                shovelService.prepareForView(status);
                Map<String, IStatus> statusMap = new HashMap<String, IStatus>();
                statusMap.put(String.valueOf(friend.getPassiveId()), status);
                request_.setAttribute("statuses", statusMap);
            }
            
            forward = formatType.getId();
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setFriendshipForm(IFriendsForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
