package jp.sourceforge.shovel;

public enum GrowlPriorityType {
    VERY_LOW    (-2),
    MODERATE    (-1),
    NORMAL      (0),
    HIGH        (1),
    EMERGENCY   (2);
    
    int id_;
    
    public int getId() {
        return id_;
    }
    GrowlPriorityType(int id) {
        id_ = id;
    }
    public GrowlPriorityType find(byte id) {
        for (GrowlPriorityType type : GrowlPriorityType.values()) {
            if(id == type.getId()) {
                return type;
            }
        }
        return null;
    }
    public boolean isVeryLow() {
        return this == VERY_LOW;
    }
    public boolean isModerate() {
        return this == MODERATE;
    }
    public boolean isNormal() {
        return this == NORMAL;
    }
    public boolean isHigh() {
        return this == HIGH;
    }
    public boolean isEmergency() {
        return this == EMERGENCY;
    }
}
