package jp.sourceforge.shovel.logic;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IDirectoryLogic {
    /**
     * ユーザの取得
     * @param userId  ユーザID
     * @return IUserオブジェクト
     */
    IUser getUser(long userId);
    /**
     * ユーザを取得
     * @param foreignKey  ユーザ名
     * @return  IUserオブジェクト
     */
    IUser getUserByForeignKey(String foreignKey);
    /**
     * ユーザを取得
     * @param foreignKey  ユーザ名
     * @param email E-Mailアドレスでも検索する
     * @return  IUserオブジェクト
     */
    IUser getUserByForeignKeyOrEmail(String foreignKey, boolean email);
    /**
     * ユーザの取得
     * @param deviceType  デバイスタイプ
     * @param address  デバイスのアカウントID
     * @return  IUserオブジェクト
     */
    IUser getUserByDevice(String deviceType, String address);
    /**
     * （削除されてない）ユーザリストの取得
     * @param sortType  順序変更を行うカラム
     * @param sortOrderType  順序（昇順、降順）
     * @param offset  リストのオフセット
     * @param limit  リスト件数
     * @return  IUserオブジェクト一覧
     */
    IUser[] getUsers(SortType sortType, SortOrderType sortOrderType, int offset, int limit);
    /**
     * ユーザリストの取得
     * @param userIds  ユーザIDリスト
     * @return  IUserオブジェクト一覧
     */
    IUser[] getUsers(long[] userIds);
    /**
     * ユーザリストの取得
     * @param userIds  ユーザ名リスト
     * @return  IUserオブジェクト一覧
     */
    IUser[] getUsers(String[] foreignKeys);
    /**
     * ユーザの検索
     * @param keyword  検索文字列
     * @param offset  ユーザリストのオフセット
     * @param limit  ユーザリスト件数
     * @return
     */
    IUser[] searchUsers(String keyword, int offset, int limit);
    IUser[] getRandUsers(boolean remove, int offset, int limit);
    IUser createUser(String displayName, String foreignKey, String password, String email, long profileImageId,
            String location, String timeZoneId, String description, long creatorId, boolean protect) throws ApplicationException;
    IUser createTemporaryUser();
    
    int decrementFavoritesAll(long statusId);
    int decrementFavorites(long userId);
    int decrementFavorites(String foreignKey);
    int decrementGivenFavorites(long userId);
    int decrementGivenFavorites(String foreignKey);
    int decrementStatuses(long userId);
    int decrementStatuses(String foreignKey);
    int decrementDirectMessages(long userId);
    int decrementDirectMessages(String foreignKey);
    int incrementFavorites(long userId);
    int incrementFavorites(String foreignKey);
    int incrementGivenFavorites(long userId);
    int incrementGivenFavorites(String foreignKey);
    int incrementStatuses(long userId);
    int incrementStatuses(String foreignKey);
    int incrementDirectMessages(long userId);
    int incrementDirectMessages(String foreignKey);
    
    int updateUser(IUser user) throws ApplicationException;
    int updateUserFromImportCsv(IUser user) throws ApplicationException;
    int updateUserFromSettings(IUser user) throws ApplicationException;
    int updatePassword(long userId, String password);
    int updatePicture(long userId, long serverFileId);
    int updateNotices(long userId, RepliesType repliesType, boolean newFriends, boolean reply,
            boolean recipientDirectMessage, boolean growl, String growlHost, String growlPassword);
    int updateRemove(long[] userIds);
}
