package jp.sourceforge.shovel.exception;

/**
 * エラーページを出力する例外
 */
public class ApplicationException extends Exception {
    private static final long serialVersionUID = -1L;
    // キーは5桁の数字
    private static final int ERROR_KEY_LENGTH = 5;
    private String[] causeArgs_ = null;
    private String[] counterMeasureArgs_ = null;
    private String[] developerInfoArgs_ = null;
    private String[] diagnosisArgs_ = null;
    private String errorCode_;
    private String outputErrorCode_;
    private String bundle_;
    private String key_;

    public ApplicationException(String errorCode) {
        this(errorCode, null);
    }
    public ApplicationException(String errorCode, String[] diagnosisArgs) {
        this(errorCode, diagnosisArgs, null);
    }
    public ApplicationException(String errorCode, String[] diagnosisArgs, String[] causeArgs) {
        this(errorCode, diagnosisArgs, causeArgs, null);
    }
    public ApplicationException(String errorCode, String[] diagnosisArgs, String[] causeArgs, String[] counterMeasureArgs) {
        this(errorCode, diagnosisArgs, causeArgs, counterMeasureArgs, null);
    }
    public ApplicationException(String errorCode, String[] diagnosisArgs, String[] causeArgs, String[] counterMeasureArgs, String[] developerInfoArgs) {
        super();
        setErrorCode(errorCode);
        setDiagnosisArgs(diagnosisArgs);
        setCauseArgs(causeArgs);
        setCounterMeasureArgs(counterMeasureArgs);
        setDeveloperInfoArgs(developerInfoArgs);
        Throwable t = fillInStackTrace();
        setStackTrace(t.getStackTrace());
    }
    void setErrorCode(String errorCode) {
        if (errorCode == null || errorCode.length() <= 0) {
            errorCode = "APPLICATION00000";
        }
        errorCode_ = errorCode;
        int end = errorCode.length();
        int begin = end - ERROR_KEY_LENGTH;
        bundle_ = errorCode.substring(0, begin).toUpperCase();
        key_ = errorCode.substring(begin, end);
    }
    public String getErrorCode() {
        return errorCode_;
    }
    public void setOutputErrorCode(String errorCode) {
        outputErrorCode_ = errorCode;
    }
    public String getOutputErrorCode() {
        return outputErrorCode_;
    }
    public String getBundle() {
        return bundle_;
    }
    public String getKey() {
        return key_;
    }
    public void setCauseArgs(String[] causeArgs) {
        if (causeArgs_ != null) {
            causeArgs_ = causeArgs;
        }
    }
    public void setCauseArgs(String arg1) {
        setCauseArgs(arg1, null);
    }
    public void setCauseArgs(String arg1, String arg2) {
        setCauseArgs(arg1, arg2, null);
    }
    public void setCauseArgs(String arg1, String arg2, String arg3) {
        setCauseArgs(arg1, arg2, arg3, null);
    }
    public void setCauseArgs(String arg1, String arg2, String arg3, String arg4) {
        setCauseArgs(arg1, arg2, arg3, arg4, null);
    }
    public void setCauseArgs(String arg1, String arg2, String arg3, String arg4, String arg5) {
        setCauseArgs( new String[]{arg1, arg2, arg3, arg4, arg5});
    }
    public String[] getCauseArgs() {
        return causeArgs_;
    }
    public void setCounterMeasureArgs(String[] counterMeasureArgs) {
        if (counterMeasureArgs_ != null) {
            counterMeasureArgs_ = counterMeasureArgs;
        }
    }
    public void setCounterMeasureArgs(String arg1) {
        setCounterMeasureArgs(arg1, null);
    }
    public void setCounterMeasureArgs(String arg1, String arg2) {
        setCounterMeasureArgs(arg1, arg2, null);
    }
    public void setCounterMeasureArgs(String arg1, String arg2, String arg3 ) {
        setCounterMeasureArgs(arg1, arg2, arg3, null);
    }
    public void setCounterMeasureArgs(String arg1, String arg2, String arg3, String arg4 ) {
        setCounterMeasureArgs(arg1, arg2, arg3, arg4, null);
    }
    public void setCounterMeasureArgs(String arg1, String arg2, String arg3, String arg4, String arg5) {
        setCounterMeasureArgs(new String[]{arg1, arg2, arg3, arg4, arg5});
    }
    public String[] getCounterMeasureArgs() {
        return counterMeasureArgs_;
    }
    public void setDeveloperInfoArgs(String[] developerInfoArgs) {
        if (developerInfoArgs_ != null) {
            developerInfoArgs_ = developerInfoArgs;
        }
    }
    public void setDeveloperInfoArgs(String arg1) {
        setDeveloperInfoArgs(arg1, null);
    }
    public void setDeveloperInfoArgs(String arg1, String arg2) {
        setDeveloperInfoArgs(arg1, arg2, null);
    }
    public void setDeveloperInfoArgs(String arg1, String arg2, String arg3) {
        setDeveloperInfoArgs(arg1, arg2, arg3, null);
    }
    public void setDeveloperInfoArgs(String arg1, String arg2, String arg3, String arg4) {
        setDeveloperInfoArgs(arg1, arg2, arg3, arg4, null);
    }
    public void setDeveloperInfoArgs(String arg1, String arg2, String arg3, String arg4, String arg5) {
        setDeveloperInfoArgs(new String[]{arg1, arg2, arg3, arg4, arg5});
    }
    public String[] getDeveloperInfoArgs() {
        return developerInfoArgs_;
    }
    public void setDiagnosisArgs(String[] diagnosisArgs) {
        if (diagnosisArgs_ != null) {
            diagnosisArgs_ = diagnosisArgs;
        }
    }
    public void setDiagnosisArgs(String arg1) {
        setDiagnosisArgs(arg1, null);
    }
    public void setDiagnosisArgs(String arg1, String arg2) {
        setDiagnosisArgs(arg1, arg2, null);
    }
    public void setDiagnosisArgs(String arg1, String arg2, String arg3) {
        setDiagnosisArgs(arg1, arg2, arg3, null);
    }
    public void setDiagnosisArgs(String arg1, String arg2, String arg3, String arg4) {
        setDiagnosisArgs(arg1, arg2, arg3, arg4, null);
    }
    public void setDiagnosisArgs(String arg1, String arg2, String arg3, String arg4, String arg5) {
        setDiagnosisArgs(new String[]{ arg1, arg2, arg3, arg4, arg5});
    }
    public String[] getDiagnosisArgs() {
        return diagnosisArgs_;
    }
}
