package jp.sourceforge.shovel.entity;

import java.io.InputStream;
import java.io.OutputStream;

import jp.sourceforge.shovel.SizeType;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IServerFile {
    void setServerFileId(long serverFileId);
    long getServerFileId();
    void setName(String name);
    String getName();
    void setMime(String mime);
    String getMime();
    void setSize(int size);
    int getSize();
    void setCharset(String charset);
    String getCharset();
    int getWidth();
    void setWidth(int width);
    int getHeight();
    void setHeight(int height);
    long getCreatedTime();
    void setCreatedTime(long createdTime);
    
    ISize getOriginal();
    ISize getSmall();
    ISize getMiddle();
    ISize getLarge();
    ISize getXlarge();
    String getContentType();
    void setContentType(String contentType);
    
    void createThumbnail(SizeType sizeType) throws ApplicationException;
    void createTemporaryThumbnail(SizeType sizeType) throws ApplicationException;
    
    boolean isExists(SizeType sizeType) throws ApplicationException;
    boolean isExists();
    void commit(int process) throws ApplicationException;
    void commit(SizeType sizeType) throws ApplicationException;
    void remove() throws Exception;
    void download(OutputStream output, SizeType sizeType) throws ApplicationException;
    InputStream getInputStream() throws ApplicationException;
    void setInputStream(InputStream inputStream) throws ApplicationException;
    boolean isImage();
    void prepare() throws ApplicationException;
    void prepareForView();
    Object clone();
}
