package jp.sourceforge.shovel.device;

import jp.sourceforge.shovel.exception.ApplicationException;

abstract public interface IDelayExecutor {
    /**
     * 実行器の表示名の取得
     * @return  デバイスの表示名（文字列）
     */
    String getDisplayName();
    /**
     * 遅延処理の実行器IDの取得
     * @return  遅延処理の実行器ID（文字列）
     */
    abstract String getExecutorId();
    /**
     * デバイスの登録アドレス（アカウントIDであることが多い）
     * @return  デバイスの登録アドレス（nullならdeviceとしない）
     */
    String getAddress();
    /**
     * im.propertiesの読み込みコールバック
     * @param key  キー
     * @param value  値
     */
    abstract void setProperty(String key, String value);
    
    /////
    
    /**
     * 配信サーバに接続
     */
    void connect() throws ApplicationException;
    /**
     * 配信サーバへの接続を切断
     */
    void disconnect();
    /**
     * 接続状態の確認
     */
    abstract boolean isConnected();
    /**
     * 遅延処理の実行
     */
    abstract void execute(IDelayExecutorContext context) throws ApplicationException;
}
