package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.impl.FriendshipImpl;

@S2Dao(bean = FriendshipImpl.class)
public interface IFriendshipDao {
    int insert(IFriendship friendship);
    
    @Arguments("friendship")
    int update(IFriendship freidnship);
    @Arguments({"friendshipId", "accept", "createdTime"})
    int updateAccept(long friendshipId, boolean accept, long createdTime);
    @Arguments({"activeId", "passiveId", "accept", "createdTime"})
    int updateAcceptByForeignKey(String activeId, long passiveId, boolean accept, long createdTime);
    @Arguments({"activeId", "passiveId", "accept", "createdTime"})
    int updateAcceptByUserId(long activeId, long passiveId, boolean accept, long createdTime);
    @Arguments({"friendshipIds", "accept", "createdTime", "notify", "removedTime"})
    int updateAll(long[] freidnshipIds, boolean accept, long createdTime, boolean notify, long removedTime);
    @Arguments({"friendshipIds", "removedTime"})
    int updateAllRemoved(long[] friendshipIds, long removedTime);
    @Arguments({"activeId", "passiveId", "notify"})
    int updateNotifyByUserId(long activeId, long passiveId, boolean notify);
    @Arguments({"activeId", "passiveId", "notify"})
    int updateNotifyByForeignKey(long activeId, String passiveId, boolean notify);
    @Arguments({"activeId", "passiveId", "removedTime"})
    int updateRemoved(long activeId, long passiveId, long removedTime);
    
    @Arguments({"activeId", "passiveId"})
    IFriendship find(long activeId, long passiveId);
    @Arguments({"activeId", "passiveId"})
    IFriendship findByPassiveForeignKey(long activeId, String passiveId);
    @Arguments({"activeId", "passiveId"})
    IFriendship findByActiveForeignKey(String activeId, long passiveId);
    
    @Arguments({"activeId", "offset", "limit"})
    IFriendship[] findAllFriends(long activeId, int offset, int limit);
    @Arguments({"activeId", "passiveIds", "offset", "limit"})
    IFriendship[] findAllFriendsBy(long activeId, long[] passiveIds, int offset, int limit);

    @Arguments({"passiveId", "offset", "limit"})
    IFriendship[] findAllFollowers(long passiveId, int offset, int limit);
    @Arguments({"passiveId", "activeIds", "offset", "limit"})
    IFriendship[] findAllFollowersBy(long passiveId, long[] activeIds, int offset, int limit);
    @Arguments({"passiveId", "offset", "limit"})
    IFriendship[] findAllFollowersByGrowl(long passiveId, int offset, int limit);
    @Arguments({"passiveId", "deviceType", "offset", "limit"})
    IFriendship[] findAllFollowersByDevice(long passiveId, String deviceType, int offset, int limit);
    @Arguments({"passiveId", "offset", "limit"})
    IFriendship[] findAllRequests(long passiveId, int offset, int limit);

    //削除したレコードも
    @Arguments({"activeId", "passiveId"})
    IFriendship[] find2WayRequests(long activeId, long passiveId);
    @Arguments({"activeId", "passiveId"})
    IFriendship[] find2WayRequestsByForeignKey(String activeId, long passiveId);

    @Arguments("activeId")
    int countProtectFriends(long activeId);
    @Arguments("activeId")
    int countPublicFriends(long activeId);
    @Arguments("passiveId")
    int countAllFollowers(long passiveId);
    @Arguments("passiveId")
    int countAcceptFollowers(long passiveId);
    @Arguments("passiveId")
    int countRequestFollowers(long passiveId);
}
