package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.impl.DirectMessageImpl;

@S2Dao(bean = DirectMessageImpl.class)
public interface IDirectMessageDao {
    int insert(IDirectMessage directMessage);
    
    @Arguments({"directMessageId", "sent", "removedTime"})
    int updateRemovedTime(long directMessageId, boolean sent, long removedTime);
    
    @Arguments("directMessageId")
    IDirectMessage find(long directMessageId);
    @Arguments({"userId", "sent", "offset", "limit"})
    IDirectMessage[] findAll(long userId, boolean sent, int offset, int limit);
    @Arguments({"userId", "sent", "sinceId", "limit"})
    IDirectMessage[] findAllSinceId(long userId, boolean sent, long sinceId, int limit);
    @Arguments({"userId", "sent", "sentTime", "limit"})
    IDirectMessage[] findAllSinceTime(long userId, boolean sent, long sentTime, int limit);
}
