package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.CommonConst.*;
import static jp.sourceforge.shovel.SessionConst.*;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.ErrorPageType;
import jp.sourceforge.shovel.action.IRootAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.form.ILoginForm;
import jp.sourceforge.shovel.mobilephone.IMobilePhone;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.HttpUtil;

public class RootActionImpl implements IRootAction {
    IShovelService shovelService_;
    ILoginForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    
    S2Container container_;
    public void setContainer(S2Container container) {
        container_ = container;
    }
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        if (getSession().isNew() && !shovelService_.isMobilePhone()) {
            //初回アクセスのjsessionidを消すためのリダイレクト
            //jsesionidを付けたくないのでencodeURLしない
            //HttpUtil.sendRedirect(response_, "/");
            response_.sendRedirect("/");
            return null;
        }
        
        //クライアントからログアウトを要求された
        if (actionForm_.isLogout()) {
            shovelService_.getDirectoryService().logout();
            //トップページにリダイレクト
            HttpUtil.sendRedirect(response_, "/");
            return null;
        }
        
        //ログイン後ならHomeにリダイレクト
        if (getSession().getAttribute(S_LOGIN) != null) {
            HttpUtil.sendRedirect(response_, "/home");
            return null;
        }
        
        //「次回もこのログイン名を使用する」がON
        Cookie[] cookies = request_.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().compareTo(LOGIN_COOKIE_NAME) == 0) {
                    actionForm_.setAccount(cookie.getValue());
                    actionForm_.setSaveAccount(true);
                    break;
                }
            }
        }
        
        String notification = (String)getSession().getAttribute(S_NOTIFICATION);
        getSession().removeAttribute(S_NOTIFICATION);
        
        //クッキーより書き戻しを優先させる
        /*ILoginForm sessionForm = (ILoginForm)getSession().getAttribute(S_ACTION_FORM);
        if (sessionForm != null) {
            actionForm_.setAccount(sessionForm.getAccount());
            actionForm_.setSaveAccount(sessionForm.isSaveAccount());
            //書き戻しはログインの失敗が起因
            //String errorCode = (String)getSession().getAttribute(S_ERROR_CODE);
            getSession().removeAttribute(S_ERROR_CODE);
            getSession().removeAttribute(S_ACTION_FORM);
            notification = "warning.loginFailure";
        }*/
        
        //通知
        if (notification != null) {
            request_.setAttribute("notification", notification);
        }
        
        ErrorPageType errorPageType = (ErrorPageType)request_.getAttribute(ERROR_PAGE_TYPE);
        if (errorPageType.isXhr()) {
            //Ajaxによるリクエストはコンテンツを空で
            return null;
        }
        
        IMobilePhone mobilePhone = shovelService_.getMobilePhone();
        if (mobilePhone != null) {
            return ROOT_MOBILE;
        }
        return ROOT;
    }
    public void setShovelService(IShovelService shovelService) {
        shovelService_ = shovelService;
    }
    public void setLoginForm(ILoginForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    HttpSession getSession() {
        return request_.getSession(true);
    }
}
