package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.SessionConst.*;
import static jp.sourceforge.shovel.ViewType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IPublicTimelineAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class PublicTimelineActionImpl implements IPublicTimelineAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        
        int page = actionForm_.getPage();
        int limit = actionForm_.getCount();
        IStatus[] tmp;
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)getSession().getAttribute(S_LIST_REFINE);
            if (listRefine == null || !listRefine.getViewType().isPublicTimeline()) {
                listRefine = (IListRefine)container_.getComponent(IListRefine.class);
                getSession().setAttribute(S_LIST_REFINE, listRefine);
            } else if (actionForm_.getMethodType().isPage()) {
                listRefine.setPage(actionForm_.getPage());
            }
            listRefine.setViewType(PUBLIC_TIMELINE);
            
            if (!shovelService.isMobilePhone()) {
                page = listRefine.getPage();
            }
            limit = 0;
            
            tmp = shovelService.getStatuses(page, limit);
        } else {
            String since = actionForm_.getSince();
            if (since == null || since.length() <= 0) {
                since = request_.getHeader("If-Modified-Since");
            }
            if (since == null || since.length() <= 0) {
                tmp = shovelService.getStatuses(actionForm_.getSince_id(), limit);
            } else {
                tmp = shovelService.getStatuses(actionForm_.getSince(), actionForm_.isUseRemoved(), limit);
            }
        }
        IStatus[] statuses = shovelService.prepareForView(tmp, limit, true);
        boolean nextPage = false;
        if (statuses != null && statuses.length > 0) {
            nextPage = tmp.length > statuses.length;
        }
        request_.setAttribute("useRemoved", actionForm_.isUseRemoved());
        request_.setAttribute("nextPage", nextPage);
        request_.setAttribute("statuses", statuses);
        String forward = null;
        switch (formatType) {
        case HTML:
            if (shovelService.isMobilePhone()) {
                request_.setAttribute("page", page);
                forward = FORWARD_MOBILE;
            } else {
                if (user == null) {
                    IUser[] introductions = directoryService.getRandUsers();
                    shovelService.prepareForView(introductions, introductions.length);
                    request_.setAttribute("introductions", introductions);
                } else {
                    shovelService.prepareForView(user);
                    request_.setAttribute("user", user);
                    String foreignKey = user.getForeignKey();
                    IFriendship[] friendships = shovelService.getFriends(foreignKey, 0, 100);
                    request_.setAttribute("viewAllFriends", friendships.length > 100);
                    friendships = shovelService.prepareForView(friendships, 100, true);
                    request_.setAttribute("friendships", friendships);
                }
                forward = actionForm_.isPartial() ? FORWARD_AJAX : FORWARD_HTML;
            }
            break;
        case JSON:
        case XML:
            forward = formatType.getId();
            break;
        case ATOM:
        case RSS:
            shovelService.outputFeed(formatType, PUBLIC_TIMELINE, user, statuses);
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    public void setStatusesForm(IStatusesForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    HttpSession getSession() {
        return request_.getSession(true);
    }
}
