package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.ICreateFavoriteAction;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusForm;
import jp.sourceforge.shovel.service.IShovelService;

public class CreateFavoriteActionImpl implements ICreateFavoriteAction {
    IStatusForm actionForm_;
    HttpServletRequest request_;
    
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        shovelService.createFavorite(actionForm_.getStatusId());
        
        String forward = null;
        switch (formatType) {
        case HTML:
            if (shovelService.isMobilePhone()) {
                request_.setAttribute("post", "createFavorite");
                forward = MOBILE;
            }
            break;
        case JSON:
        case XML:
            IStatus status = shovelService.getStatus(actionForm_.getStatusId());
            shovelService.prepareForView(status);
            request_.setAttribute("status", status);
            
            forward = formatType.getId();
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setStatusForm(IStatusForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
