package jp.sourceforge.shovel;

public enum StatusType {
    STATUS          ("status"),
    DIRECT_MESSAGE  ("directMessage"),
    FAVORITE        ("favorite"),
    FRIEND_REQUEST  ("friendRequest"),
    FOLLOW          ("follow"),
    LEAVE           ("leave"),
    NOTIFY_ON       ("notifyOn"),
    NOTIFY_OFF      ("notifyOff"),
    SLEEP           ("sleep"),
    WAKE            ("wake");
    
    String key_;
    
    StatusType(String key) {
        key_ = key;
    }
    public String getKey() {
        return key_;
    }
    public static StatusType find(String key) {
        for (StatusType type :StatusType.values()) {
            if (key.compareTo(type.getKey()) == 0) {
                return type;
            }
        }
        return null;
    }
    public boolean isStatus() {
        return this == STATUS;
    }
    public boolean isDirectMessage() {
        return this == DIRECT_MESSAGE;
    }
    public boolean isFavorite() {
        return this == FAVORITE;
    }
    public boolean isFriendRequest() {
        return this == FRIEND_REQUEST;
    }
    public boolean isFollow() {
        return this == FOLLOW;
    }
    public boolean isLeave() {
        return this == LEAVE;
    }
    public boolean isNotifyOn() {
        return this == NOTIFY_ON;
    }
    public boolean isNotifyOff() {
        return this == NOTIFY_OFF;
    }
    public boolean isSleep() {
        return this == SLEEP;
    }
    public boolean isWake() {
        return this == WAKE; 
    }
}
