package jp.sourceforge.shovel.logic.impl;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IMobilePhoneLogic;
import jp.sourceforge.shovel.mobilephone.impl.DoCoMoImpl;
import jp.sourceforge.shovel.mobilephone.impl.EZwebImpl;
import jp.sourceforge.shovel.mobilephone.impl.SoftBankImpl;
import junit.framework.Assert;

import org.junit.runner.RunWith;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.TestContext;

@RunWith(Seasar2.class)
public class MobileLogicImplTest {
    TestContext context_;
    HttpServletRequest request_;
    IMobilePhoneLogic logic_;
    
    public void testShouldCreateAnObjectByAGivenUserAgentString() throws ApplicationException {
        String userAgent = "DoCoMo/2.0 P706imyu(c100;TB;W24H15)";
        Assert.assertEquals(DoCoMoImpl.class, logic_.createMobilePhone(userAgent).getClass());
        userAgent = "KDDI-SA31 UP.Browser/6.2.0.7.3.129 (GUI) MMP/2.0";
        Assert.assertEquals(EZwebImpl.class, logic_.createMobilePhone(userAgent).getClass());
        userAgent = "SoftBank/1.0/706SC/SCJ001 Browser/NetFront/3.3 Profile/MIDP-2.0 Configuration/CLDC-1.1";
        Assert.assertEquals(SoftBankImpl.class, logic_.createMobilePhone(userAgent).getClass());
        //userAgent = "Mozilla/3.0(DDIPOCKET;JRC/AH-J3001V,AH-J3002V/1.0/0100/c50)CNF/2.0";
        //Assert.assertEquals(WillcomImpl.class, logic_.createMobilePhone(userAgent).getClass());
        userAgent = "Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.8.1.4) Gecko/20070515 Firefox/2.0.0.4 GoogleToolbarFF 3.0.20070525";
        Assert.assertNull(logic_.createMobilePhone(userAgent));
    }
    
    public void testShouldCreateAnObjectByTheHttpHeaderInAnEnvironment() throws ApplicationException {
        String userAgent = "DoCoMo/2.0 P706imyu(c100;TB;W24H15)";
        MockHttpServletRequest request = (MockHttpServletRequest)request_;
        request.addHeader("User-Agent", userAgent);
        Assert.assertEquals(DoCoMoImpl.class, logic_.createMobilePhone(userAgent).getClass());
    }
    
    public void testShouldTellWhetherAUserAgentIsDocomo() {
        String userAgent = "DoCoMo/2.0 P706imyu(c100;TB;W24H15)";
        Assert.assertTrue(logic_.isDoCoMo(userAgent));
        Assert.assertFalse(logic_.isEZweb(userAgent));
        Assert.assertFalse(logic_.isSoftBank(userAgent));
        //Assert.assertFalse(logic_.isWillcom(userAgent));
    }
    
    public void testShouldTellWhetherAUserAgentIsEzweb() {
        String userAgent = "KDDI-SA31 UP.Browser/6.2.0.7.3.129 (GUI) MMP/2.0";
        Assert.assertFalse(logic_.isDoCoMo(userAgent));
        Assert.assertTrue(logic_.isEZweb(userAgent));
        Assert.assertFalse(logic_.isSoftBank(userAgent));
        //Assert.assertFalse(logic_.isWillcom(userAgent));
    }

    public void testShouldTellWhetherAUserAgentIsSoftbank() {
        String userAgent = "SoftBank/1.0/706SC/SCJ001 Browser/NetFront/3.3 Profile/MIDP-2.0 Configuration/CLDC-1.1";
        Assert.assertFalse(logic_.isDoCoMo(userAgent));
        Assert.assertFalse(logic_.isEZweb(userAgent));
        Assert.assertTrue(logic_.isSoftBank(userAgent));
        //Assert.assertFalse(logic_.isWillcom(userAgent));
    }

    //public void testShouldTellWhetherAUserAgentIsWillcom() {
        //String userAgent = "Mozilla/3.0(DDIPOCKET;JRC/AH-J3001V,AH-J3002V/1.0/0100/c50)CNF/2.0";
        //Assert.assertFalse(logic_.isDoCoMo(userAgent));
        //Assert.assertFalse(logic_.isEZweb(userAgent));
        //Assert.assertFalse(logic_.isSoftBank(userAgent));
        //Assert.assertTrue(logic_.isWillcom(userAgent));
    //
    
    public void testShouldTellWhetherAUserAgentIsDocomoByTheHttpHeaderInAnEnvironment() {
        String userAgent = "DoCoMo/2.0 P706imyu(c100;TB;W24H15)";
        MockHttpServletRequest request = (MockHttpServletRequest)request_;
        request.addHeader("User-Agent", userAgent);
        Assert.assertTrue(logic_.isDoCoMo(userAgent));
        Assert.assertFalse(logic_.isEZweb(userAgent));
        Assert.assertFalse(logic_.isSoftBank(userAgent));
        //Assert.assertFalse(logic_.isWillcom(userAgent));
    }
    
    public void testShouldTellWhetherAUserAgentIsEzwebByTheHttpHeaderInAnEnvironment() {
        String userAgent = "KDDI-SA31 UP.Browser/6.2.0.7.3.129 (GUI) MMP/2.0";
        MockHttpServletRequest request = (MockHttpServletRequest)request_;
        request.addHeader("User-Agent", userAgent);
        Assert.assertFalse(logic_.isDoCoMo(userAgent));
        Assert.assertTrue(logic_.isEZweb(userAgent));
        Assert.assertFalse(logic_.isSoftBank(userAgent));
        //Assert.assertFalse(logic_.isWillcom(userAgent));
    }

    public void testShouldTellWhetherAUserAgentIsSoftbankByTheHttpHeaderInAnEnvironment() {
        String userAgent = "SoftBank/1.0/706SC/SCJ001 Browser/NetFront/3.3 Profile/MIDP-2.0 Configuration/CLDC-1.1";
        MockHttpServletRequest request = (MockHttpServletRequest)request_;
        request.addHeader("User-Agent", userAgent);
        Assert.assertFalse(logic_.isDoCoMo(userAgent));
        Assert.assertFalse(logic_.isEZweb(userAgent));
        Assert.assertTrue(logic_.isSoftBank(userAgent));
        //Assert.assertFalse(logic_.isWillcom(userAgent));
    }

    //public void testShouldTellWhetherAUserAgentIsWillcomByTheHttpHeaderInAnEnvironment() {
        //String userAgent = "Mozilla/3.0(DDIPOCKET;JRC/AH-J3001V,AH-J3002V/1.0/0100/c50)CNF/2.0";
        //MockHttpServletRequest request = (MockHttpServletRequest)request_;
        //request.addHeader("User-Agent", userAgent);
        //Assert.assertFalse(logic_.isDoCoMo(userAgent));
        //Assert.assertFalse(logic_.isEZweb(userAgent));
        //Assert.assertFalse(logic_.isSoftBank(userAgent));
        //Assert.assertTrue(logic_.isWillcom(userAgent));
    //}

}
