package jp.sourceforge.shovel.logic;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IShovelLogic {
    /**
     * Status
     */
    IStatus getStatus(long statusId);
    IStatus getRecent(long userId);
    IStatus[] getFavorites(long userId, int offset, int limit);
    IStatus[] getStatuses(int offset, int limit);
    IStatus[] getStatuses(String since, boolean useRemoved, int limit) throws ApplicationException;
    IStatus[] getStatuses(long sinceId, int limit);
    IStatus[] getStatuses(SortType sortType, SortOrderType sortOrderType, int limit);
    IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, int offset, int limit);
    IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, String since, int limit) throws ApplicationException;
    IStatus[] getRecents(long[] userIds);
    IStatus[] getReplies(long userId, int offset, int limit);
    IStatusWrapper parseStatus(String status);
    IStatus updateStatus(String body, String location, String source, long referenceSenderId, boolean open, long senderId, boolean delayCommit) throws ApplicationException;
    int decrementGivenFavorites(long statusId);
    int clearStatusReference(long statusId);
    void receiveStatus(String body, String location, String source, long referenceSenderId, boolean open, long senderId) throws ApplicationException;
    int destroyStatus(long statusId, boolean delayCommit) throws ApplicationException;
    
    /**
     * DirectMessage
     */
    IDirectMessage getDirectMessage(long directMessageId);
    IDirectMessage[] getDirectMessages(long userId, boolean sent, int offset, int limit);
    IDirectMessage[] getDirectMessages(long userId, boolean sent, long sinceId, int limit);
    IDirectMessage[] getDirectMessages(long userId, boolean sent, String sentTime, int limit) throws ApplicationException;
    
    IDirectMessage createDirectMessage(String text, String source, long receiverId, long senderId, boolean delayCommit) throws ApplicationException;
    int destroyDirectMessage(long directMessageId, boolean sent, boolean delayCommit) throws ApplicationException;
    
    /**
     * Friendship
     */
    IFriendship getFriendship(long activeId, long passiveId);
    IFriendship getFriendship(long activeId, String foreignKey);
    IFriendship getFriendship(String activeId, long foreignKey);
    IFriendship[] getFriends(long activeId, long[] passiveIds);
    IFriendship[] getFriends(long activeId, int offset, int limit);
    //allow or all
    IFriendship[] getFollowers(long passiveId, boolean growl, int offset, int limit);
    IFriendship[] getFollowers(long passiveId, String deviceType, int offset, int limit);
    IFriendship[] getFollowers(long passiveId, long[] activeIds);
    IFriendship[] searchFollowing(long activeId, String[] keywords, int offset, int limit);
    IFriendship[] searchReciprocalFollow(long userId, String[] keywords, int offset, int limit);
    IFriendship[] searchFollowingOnly(long activeId, String[] keywords, int offset, int limit);
    IFriendship[] searchFollowersOnly(long passiveId, String[] keywords, int offset, int limit);
    IFriendship[] getRequests(long passiveId, int offset, int limit);
    //許可する人と申請してる人のともだち関係（双方向）
    IFriendship[] getRequests(long activeId, long passiveId);
    IFriendship[] getRequests(String activeId, long passiveId);
    
    int countPublicFriends(long activeId);
    int countProtectFriends(long activeId);
    int countAllFollowers(long activeId);
    int countAcceptFollowers(long activeId);
    int countRequestFollowers(long activeId);
    
    IFriendship createFriendship(long activeId, long passiveId, boolean protect, boolean delayCommit) throws ApplicationException;
    IFriendship destroyFriendship(long activeId, long passiveId, boolean protect, boolean delayCommit) throws ApplicationException;
    IFriendship updateNotification(long activeId, long passiveId, boolean notify) throws ApplicationException;
    IFriendship updateNotification(long activeId, String passiveId, boolean notify) throws ApplicationException;
    IFriendship acceptFriendship(long activeId, long passiveId, boolean delayCommit) throws ApplicationException;
    IFriendship denyFriendship(long activeId, long passiveId, boolean delayCommit) throws ApplicationException;
    
    /**
     * Favorite
     */
    IFavorite getFavorite(long statusId, long userId);
    IFavorite[] getFavorites(long[] statusIds, long userId);
    IFavorite[] getFavoritesByStatus(long statusId, int limit);
    IFavorite[] getFavoritesByStatuses(long[] statusIds, int limit);
    IFavorite createFavorite(long statusId, long userId, boolean delayCommit) throws ApplicationException;
    int destroyFavorite(long statusId, long userId, boolean delayCommit) throws ApplicationException;
    
    /**
     * Device
     */
    IDevice createDevice(IDevice device);
    int updateDevice(IDevice device);
    
    /**
     * Client
     */
    IDedicatedClient createClient(String key, String url, String version);
    int updateClient(IDedicatedClient client);
    IDedicatedClient getClient(String key);
    IDedicatedClient[] getClients(String[] keys);
    int removeClient(String key);
}
