package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.entity.impl.UserImpl;

@S2Dao(bean = UserImpl.class)
public interface IUserDao {
    /**
     * 登録
     * @param user
     * @return  
     */
    int insert(IUser user);
    
    /**
     * 更新
     * @param user
     * @return
     */
    @Arguments("user")
    int update(IUser user);
    /**
     * プロフィール画像の更新
     * @param userId  ユーザID
     * @param serverFileId  サーバファイルID
     * @param modifiedTime  更新日時
     * @return
     */
    @Arguments({"userId", "serverFileId", "modifiedTime"})
    int updatePicture(long userId, long serverFileId, long modifiedTime);
    /**
     * パスワードの更新
     * @param userId  ユーザID
     * @param password  パスワード
     * @param modifiedTime  更新日時
     * @return
     */
    @Arguments({"userId", "password", "modifiedTime"})
    int updatePassword(long userId, String password, long modifiedTime);
    /**
     * 通知の更新
     * 主に個人設定のため
     * @param userId  ユーザID
     * @param repliesType  リプライタイプ
     * @param modifiedTime  更新日時
     * @return
     */
    @Arguments({"userId", "repliesType", "newFriends", "reply", "recipientDirectMessage", "growl", "growlHost", "growlPassword", "modifiedTime"})
    int updateNotices(long userId, RepliesType repliesType, boolean newFriends, boolean reply, boolean recipientDirectMessage, boolean growl, String growlHost, String growlPassword, long modifiedTime);
    /**
     * CSV読み込みによる更新
     * @param user
     * @return
     */
    @Arguments("user")
    int updateFromImportCsv(IUser user);
    /**
     * 削除フラグの更新
     * @param userIds  ユーザID一覧
     * @param modifiedTime  更新日時
     * @param remove  削除フラグ
     * @return
     */
    @Arguments({"userIds", "modifiedTime", "remove"})
    int updateRemove(long[] userIds, long modifiedTime, boolean remove);
    
    @Arguments("userId")
    int updateIncrementGivenFavorites(long userId);
    @Arguments("userId")
    int updateIncrementGivenFavoritesByForeignKey(String foreignKey);
    @Arguments("userId")
    int updateDecrementGivenFavorites(long userId);
    @Arguments("foreignKey")
    int updateDecrementGivenFavoritesByForeignKey(String foreignKey);
    @Arguments("userId")
    int updateIncrementFavorites(long userId);
    @Arguments("foreignKey")
    int updateIncrementFavoritesByForeignKey(String foreignKey);
    @Arguments("statusId")
    int updateDecrementFavoritesAll(long statusId);
    @Arguments("userId")
    int updateDecrementFavorites(long userId);
    @Arguments("foreignKey")
    int updateDecrementFavoritesByForeignKey(String foreignKey);
    @Arguments("userId")
    int updateIncrementDirectMessages(long userId);
    @Arguments("foreignKey")
    int updateIncrementDirectMessagesByForeignKey(String foreignKey);
    @Arguments("userId")
    int updateDecrementDirectMessages(long userId);
    @Arguments("foreignKey")
    int updateDecrementDirectMessagesByForeignKey(String foreignKey);
    @Arguments("userId")
    int updateIncrementStatuses(long userId);
    @Arguments("foreignKey")
    int updateIncrementStatusesByForeignKey(String foreignKey);
    @Arguments("userId")
    int updateDecrementStatuses(long userId);
    @Arguments("foreignKey")
    int updateDecrementStatusesByForeignKey(String foreignKey);
    
    /**
     * 検索
     * @param userId  ユーザID
     * @return
     */
    @Arguments("userId")
    IUser find(long userId);
    /**
     * ユーザ名とE-Mailアドレスによる検索
     * @param foreignKey  ユーザ名
     * @param email E-Mailアドレス
     * @return
     */
    @Arguments({"foreignKey", "email"})
    IUser findByForeignKey(String foreignKey, boolean email);
    /**
     * デバイスによる検索
     * @param deviceType  デバイスタイプ
     * @param address  アカウントID
     * @return
     */
    @Arguments({"deviceType", "address"})
    IUser findByDevice(String deviceType, String address);
    /**
     * 一覧の検索
     * @param sortType  並び替えするカラム
     * @param sortOrderType  並び替え方法
     * @param offset  一覧オフセット
     * @param limit  一覧件数
     * @return
     */
    @Arguments({"sortType", "sortOrderType", "offset", "limit"})
    IUser[] findAll(SortType sortType, SortOrderType sortOrderType, int offset, int limit);
    /**
     * ユーザIDによる一覧の検索
     * @param userIds  ユーザID一覧
     * @param limit  一覧件数
     * @return
     */
    @Arguments({"userIds", "limit"})
    IUser[] findAllByUser(long[] userIds, int limit);
    /**
     * ユーザ名による一覧の検索
     * @param foreignKeys  ユーザ名一覧
     * @param limit  一覧件数
     * @return
     */
    @Arguments({"foreignKeys", "limit"})
    IUser[] findAllByForeignKey(String[] foreignKeys, int limit);
    @Arguments({"remove", "offset", "limit"})
    IUser[] findAllByRand(boolean remove, int offset, int limit);
}
