package jp.sourceforge.shovel.action.impl;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IUpdateStatusAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusForm;
import jp.sourceforge.shovel.service.IShovelService;

public class UpdateStatusActionImpl implements IUpdateStatusAction {
    IStatusForm actionForm_;
    S2Container container_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    
    class JSONBean {
        IStatusWrapper statusWrapper_;
        
        public JSONBean(IStatusWrapper statusWrapper) {
            statusWrapper_ = statusWrapper;
        }
        
        public String getType() {
            return statusWrapper_.getStatusType().getKey();
        }
        public String getForeignKey() {
            return statusWrapper_.getForeignKey();
        }
        public boolean isSuccess() {
            return statusWrapper_.getStatus() != null ||
                   statusWrapper_.getDirectMessage() != null ||
                   statusWrapper_.getFavorite() != null;
        }
    }
    
    @Perform(CSRF=true)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IStatusWrapper statusWrapper = shovelService.updateStatus(actionForm_.getStatus(), actionForm_.getSource());
        IStatus status = null;
        if (!shovelService.isMobilePhone()) {
            if (statusWrapper == null) {
                //TODO
                throw new ApplicationException("");
            }
           
            switch (statusWrapper.getStatusType()) {
            case STATUS:
                status = statusWrapper.getStatus();
                break;
            case DIRECT_MESSAGE:
            case FAVORITE:
            case FOLLOW:
            case FRIEND_REQUEST:
            case LEAVE:
            case NOTIFY_ON:
            case NOTIFY_OFF:
                status = shovelService.getRecent();
                break;
            default:
                //TODO
                throw new ApplicationException("");
            }
        }
        
        String forward = null;
        switch (formatType) {
        case HTML:
            if (shovelService.isMobilePhone()) {
                request_.setAttribute("post", "updateStatus");
                forward = FORWARD_MOBILE;
            } else {
                JSONBean bean = new JSONBean(statusWrapper);
                String json = net.arnx.jsonic.JSON.encode(bean);
                ServletOutputStream stream = response_.getOutputStream();
                stream.write(json.getBytes("UTF-8"));
            }
            break;
        case JSON:
        case XML:
            shovelService.prepareForView(status);
            request_.setAttribute("status", status);
            
            forward = formatType.getId();
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    public void setStatusForm(IStatusForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
