package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.action.INoticesAction;
import jp.sourceforge.shovel.form.INoticesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class NoticesActionImpl implements INoticesAction {
    INoticesForm actionForm_;
    HttpServletRequest request_;
    
    public String perform() throws Exception {
        IDirectoryService directoryService = getShovelService().getDirectoryService();
        directoryService.updateNotices(actionForm_.getRepliesType(),
                                       actionForm_.isReply(),
                                       actionForm_.isNewFriends(),
                                       actionForm_.isReceiptDirectMessage(),
                                       actionForm_.isGrowl(),
                                       actionForm_.getGrowlHost(),
                                       actionForm_.getGrowlPassword());
        return null;
    }
    public void setNoticesForm(INoticesForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
