package twitter4j.examples;

import java.util.List;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

public class Friends {
    public static void main(String[] args)throws TwitterException{
        if (args.length < 3) {
            System.out.println(
                "Usage: java twitter4j.examples.Update ID Password text");
            System.exit( -1);
        }
        Twitter twitter = new Twitter(args[0], args[1], args[2]);
        List<User> friends = twitter.getFriends();
        for (User friend : friends) {
            System.out.println(friend.getName());
        }
        System.out.println("------------------------------");
        List<User> followers = twitter.getFollowers();
        for (User follower : followers) {
            System.out.println(follower.getName());
        }
    }
}
