<#import "/macro.ftl" as macro />
<?xml version="1.0" encoding="UTF-8"?>
<#macro friend friendship>
  <#local common=JspTaglibs["/WEB-INF/tld/common.tld"] />
  <#local bean_el=JspTaglibs["http://struts.apache.org/tags-bean-el"] />
  <#if friends?has_content>
    <#local sender=friendship.passive />
  <#else>
    <#local sender=friendship.active />
  </#if>
<user>
  <id>${sender.userId}</id>
  <name><@common.ncrEncode data=sender.displayName /></name>
  <screen_name>${sender.foreignKey}</screen_name>
  <location><@common.ncrEncode data=sender.location /></location>
  <description><@common.ncrEncode data=sender.description /></description>
  <profile_image_url><@macro.userThumbnailUrl user=sender /></profile_image_url><#lt />
  <protected>false</protected>
  <followers_count>${sender.followers}</followers_count>
  <#assign status=statuses[sender.userId?string]?default("") />
  <#if status?has_content>
  <status>
    <created_at><#rt />
      <@common.dateFormat date=status.sentTime format="dateTime.compatible.twitter" timeZoneID="UTC" lang="en" /><#t />
    </created_at><#lt />
    <id>${status.statusId}</id>
    <text><@common.ncrEncode data=status.body /></text>
    <source><@macro.sourceWithLink source=status.source dedicatedClient=status.dedicatedClient escape="xml" /></source>
    <truncated>false</truncated>
    <#if status.referenceId &gt; 0>
    <in_reply_to_status_id>${status.referenceId}</in_reply_to_status_id>
    <in_reply_to_user_id>${status.referenceSenderId}</in_reply_to_user_id>
    <#else>
    <in_reply_to_status_id />
    <in_reply_to_user_id />
    </#if>
    <favorited><#rt />
    <#if status.favorite?has_content>
      true<#t />
    <#else>
      false<#t />
    </#if>
    </favorited><#lt />
  </status>
  <#else>
  <status />
  </#if>
</user>
</#macro>
<#if friendship?has_content>
<@friend friendship=friendship />
<#else>
<users>
  <#list friendships as friendship>
    <@friend friendship=friendship />
  </#list>
</users>
</#if>
