<?xml version="1.0" encoding="UTF-8"?>
<#macro exportDirectMessage directMessage>
<#local common=JspTaglibs["/WEB-INF/tld/common.tld"] />
<#local bean_el=JspTaglibs["http://struts.apache.org/tags-bean-el"] />
<#import "/macro.ftl" as macro />
<direct_message>
  <id>${directMessage.directMessageId}</id>
  <text><@common.ncrEncode data=directMessage.text /></text>
  <sender_id>${directMessage.senderId}</sender_id>
  <recipient_id>${directMessage.recipientId}</recipient_id>
  <created_at><@common.dateFormat date=directMessage.sentTime format="dateTime.compatible.twitter" timeZoneID="UTC" lang="en" /></created_at>
<#assign sender=directMessage.sender?default("")/>
<#if sender?has_content>
  <sender>
    <id>${sender.userId}</id>
	<name><@common.ncrEncode data=sender.displayName /></name>
    <screen_name>${sender.foreignKey}</screen_name>
	<location><@common.ncrEncode data=sender.location /></location>
    <description><@common.ncrEncode data=sender.description /></description>
	<profile_image_url><@macro.userThumbnailUrl user=sender /></profile_image_url>
    <protected>false</protected>
    <followers_count>${sender.followers}</followers_count>
  </sender>
<#else>
  <sender/>
</#if>
<#assign recipient=directMessage.recipient?default("")/>
<#if recipient?has_content>
  <recipient>
    <id>${recipient.userId}</id>
	<name><@common.ncrEncode data=recipient.displayName /></name>
    <screen_name>${recipient.foreignKey}</screen_name>
	<location><@common.ncrEncode data=recipient.location /></location>
    <description><@common.ncrEncode data=recipient.description /></description>
    <profile_image_url><@macro.userThumbnailUrl user=recipient /></profile_image_url>
    <protected>false</protected>
    <followers_count>${recipient.followers}</followers_count>
  </recipient>
<#else>
  <recipient/>
</#if>
</direct_message>
</#macro>
<#if directMessages?has_content>
<direct-messages>
<#list directMessages as directMessage>
  <@exportDirectMessage directMessage=directMessage />
</#list>
</direct-messages>
<#elseif directMessage?has_content>
<@exportDirectMessage directMessage=directMessage />
</#if>
